#This file is part of Tryton.  The COPYRIGHT file at the top level of
#this repository contains the full copyright notices and license terms.
from trytond.pool import Pool
from .move import *
from .party import *
from .invoice import *
from .account import *
from .tax import *

def register():
    Pool.register(
        Tax,
        Company,
        Address,
        CashflowTemplate,
        Cashflow,
        Account,
        Party,
        Move,
        Line,
        Invoice,
        InvoiceForceDrawStart,
        AuxiliaryBookStart,
        AuxiliaryPartyStart,
        PrintTrialBalanceDetailedStart,
        PrintTrialBalanceStart,
        BankAccountNumber,
        OpenCashflowStart,
        MoveFixNumberStart,
        PartyWithholdingStart,
        module='account_plus', type_='model')
    Pool.register(
        AccountMoveSheet,
        AuxiliaryBook,
        AuxiliaryParty,
        TrialBalanceDetailed,
        PortfolioByPartyDetailed,
        TrialBalance,
        BalanceSheet,
        IncomeStatement,
        EquivalentInvoice,
        PartyWithholding,
        module='account_plus', type_='report')
    Pool.register(
        MoveForceDraw,
        InvoiceForceDraw,
        PrintAuxiliaryBook,
        PrintTrialBalanceDetailed,
        PrintAuxiliaryParty,
        PrintTrialBalance,
        OpenCashflowStatement,
        MoveFixNumber,
        PrintPartyWithholding,
        module='account_plus', type_='wizard')
