#This file is part of Tryton.  The COPYRIGHT file at the top level of
#this repository contains the full copyright notices and license terms.

from trytond.model import ModelView, fields
from trytond.pool import PoolMeta, Pool
from trytond.pyson import Eval
from trytond.wizard import Wizard, StateTransition
from trytond.transaction import Transaction
from trytond.modules.company import CompanyReport

__all__ = ['Invoice', 'InvoiceForceDrawStart', 'InvoiceForceDraw', 
        'EquivalentInvoice']
__metaclass__ = PoolMeta


class Invoice:
    'Invoice'
    __name__ = 'account.invoice'
    estimate_pay_date = fields.Date('Estimate Pay Date', 
            states={'readonly': Eval('state') == 'paid'}
            )


class InvoiceForceDrawStart(ModelView):
    'Invoice Force Draw'
    __name__ = 'account.invoice.force_draw.start'


class InvoiceForceDraw(Wizard):
    'Invoice Force Draw'
    __name__ = 'account.invoice.force_draw'
    start_state = 'force_draw'
    force_draw = StateTransition()

    def transition_force_draw(self):
        cursor = Transaction().cursor
        pool = Pool()
        Invoice = pool.get('account.invoice')
        ids = Transaction().context['active_ids']
        id_invoice = str(ids[0])
        query = "UPDATE account_invoice SET state='validated', invoice_report_cache=NULL WHERE id=%s"
        cursor.execute(query % id_invoice)

        invoice = Invoice(id_invoice)

        query = "UPDATE account_move SET state='draft' WHERE id=%s"
        cursor.execute(query % str(invoice.move.id))

        return 'end'


class EquivalentInvoice(CompanyReport):
    'Equivalent Invoice'
    __name__ = 'account.invoice.equivalent'

    @classmethod
    def __setup__(cls):
        super(EquivalentInvoice, cls).__setup__()

    @classmethod
    def parse(cls, report, objects, data, localcontext=None):
        localcontext['company'] = Transaction().context.get('company')
        return super(EquivalentInvoice, cls).parse(report,
                objects, data, localcontext)
