#This file is part of Tryton.  The COPYRIGHT file at the top level of
#this repository contains the full copyright notices and license terms.
from trytond.model import ModelView, ModelSQL, fields

__all__ = ['CityCode', 'CountryCode', 'DepartmentCode' ]


class CityCode(ModelSQL, ModelView):
    "City Code"
    __name__ = "party.city_code"
    _rec_name = 'name'
    name = fields.Char('Name', required=True)
    code = fields.Char('Code', required=True)
    department = fields.Many2One('party.department_code', 'Department')

    @classmethod
    def __setup__(cls):
        super(CityCode, cls).__setup__()


class CountryCode(ModelSQL, ModelView):
    "Country Code"
    __name__ = "party.country_code"
    _rec_name = 'name'
    name = fields.Char('Name', required=True)
    code = fields.Char('Code', required=True)

    @classmethod
    def __setup__(cls):
        super(CountryCode, cls).__setup__()


class DepartmentCode(ModelSQL, ModelView):
    "Department Code"
    __name__ = "party.department_code"
    _rec_name = 'name'
    name = fields.Char('Name', required=True)
    code = fields.Char('Code', required=True)

    @classmethod
    def __setup__(cls):
        super(DepartmentCode, cls).__setup__()

    @classmethod
    def search_rec_name(cls, name, clause):
        records = cls.search(['OR',
                ('name',) + clause[1:],
                ('code',) + clause[1:],
                ], order=[])
        if records:
            return [('id', 'in', [i.id for i in records])]
