#This file is part of Tryton.  The COPYRIGHT file at the top level of
#this repository contains the full copyright notices and license terms.
import datetime
from trytond.pool import Pool
from trytond.model import ModelView, ModelSQL, Workflow, fields

__all__ = ['Document']


class Document(Workflow, ModelSQL, ModelView):
    'Document'
    __name__ = 'document.document'
    _rec_name = 'reference'
    number = fields.Char("Number", readonly=True, select=True)
    name = fields.Char('Name', required=True)

    @classmethod
    def __setup__(cls):
        super(Document, cls).__setup__()
