#This file is part of Tryton.  The COPYRIGHT file at the top level of
#this repository contains the full copyright notices and license terms.

from trytond.pool import Pool
from .document import *
from .communication import *
from .location import *
from .configuration import *
from .category import *
from .lending import *


def register():
    Pool.register(
        TypeDocument,
        CategoryDocument,
        DocumentLocation,
        DocumentRecord,
        Document,
        Communication,
        CommunicationAttachment,
        DocumentConfiguration,
        DocumentLending,
        DocumentLendingDocument,
        DocumentCommunicationEmployee,
        CommunicationLetter,
        DocumentRecordInventoryStart,
        SearchDocumentFileStart,
        module='document', type_='model')
    Pool.register(
        CommunicationLetterReport,
        DocumentRecordInventoryReport,
        module='document', type_='report')
    Pool.register(
        DocumentRecordInventory,
        SearchDocumentFile,
        module='document', type_='wizard')
