#This file is part of Tryton.  The COPYRIGHT file at the top level of
#this repository contains the full copyright notices and license terms.

from trytond.pool import Pool
from .type_activity import *
from .location import *
from .equipment import *
from .request_service import *
from .planning import *
from .configuration import *


def register():
    Pool.register(
        MaintenanceLocation,
        Equipment,
        EquipmentOperationCard,
        TypeActivity,
        MaintenanceEquipmentPart,
        RequestService,
        PlanningPeriod,
        Planning,
        PlanningLines,
        ForecastPlanning,
        Configuration,
        CheckListService,
        CheckListEquipment,
        module='maintenance', type_='model')
    Pool.register(
        RequestServiceReport,
        module='maintenance', type_='report')
