#This file is part of Tryton.  The COPYRIGHT file at the top level of
#this repository contains the full copyright notices and license terms.
from trytond.model import ModelView, ModelSQL, ModelSingleton, fields
from trytond.pyson import Eval

__all__ = ['Configuration']


class Configuration(ModelSingleton, ModelSQL, ModelView):
    'Maintenance Configuration'
    __name__ = 'maintenance.configuration'
    maintenance_sequence = fields.Property(fields.Many2One('ir.sequence',
            'Maintenance Reference Sequence', domain=[
                ('company', 'in', [Eval('context', {}).get('company', 0),
                        None]),
                ('code', '=', 'maintenance.request_service'),
                ], required=True))
