#This file is part of Tryton.  The COPYRIGHT file at the top level
#of this repository contains the full copyright notices and license terms.
from trytond.model import fields
from trytond.modules.company import CompanyReport
from trytond.pool import PoolMeta
from trytond.pyson import Eval

__all__ = ['Sale', 'SalesmanReport']

__metaclass__ = PoolMeta

STATES = {
        'readonly': Eval('state') != 'draft',
        }


class Sale:
    __name__ = 'sale.sale'
    salesman = fields.Many2One('company.employee', 'Salesman',
        select=True, states=STATES, required=True)

    @classmethod
    def __setup__(cls):
        super(Sale, cls).__setup__()


class SalesmanReport(CompanyReport):
    __name__ = 'sale.salesman_report'
