#This file is part of Tryton.  The COPYRIGHT file at the top level of
#this repository contains the full copyright notices and license terms.
from trytond.model import ModelView, ModelSQL, fields
from trytond.pool import PoolMeta

__all__ = ['EmployeeCategory', 'CategoryWagesDefault']
__metaclass__ = PoolMeta


class EmployeeCategory(ModelSQL, ModelView):
    'Employee Category'
    __name__ = 'staff.employee_category'
    code = fields.Char('Code')
    name = fields.Char('Name', required=True)
    wages_default = fields.Many2Many('staff.employee_category-staff.wages_default',
            'employee_category', 'wage_type', 'Category - Wages Default')

    @classmethod
    def __setup__(cls):
        super(EmployeeCategory, cls).__setup__()

    def get_rec_name(self, name):
        return self.name


class CategoryWagesDefault(ModelSQL):
    'Employee Category - Wages Default'
    __name__ = 'staff.employee_category-staff.wages_default'
    employee_category = fields.Many2One('staff.employee_category', 
            'Employee Category', select=True, required=True, 
            ondelete='CASCADE')
    wage_type = fields.Many2One('staff.wage_type', 'Wage Type', select=True,
            required=True, ondelete='CASCADE')

    @classmethod
    def __setup__(cls):
        super(CategoryWagesDefault, cls).__setup__()
