#This file is part of Tryton.  The COPYRIGHT file at the top level of
#this repository contains the full copyright notices and license terms.
from trytond.model import ModelView, ModelSQL, ModelSingleton, fields

__all__ = ['PayrollConfiguration']


class PayrollConfiguration(ModelSingleton, ModelSQL, ModelView):
    'Payroll Configuration'
    __name__ = 'staff.configuration'
    staff_payroll_sequence = fields.Property(fields.Many2One('ir.sequence',
        'Payroll Sequence', required=True, domain=[
                ('code', '=', 'staff.payroll')])
                )
    default_hour_workday = fields.Integer('Default Hour Workday',
            required=True)
    default_restday = fields.Integer('Default Restday', required=True)
    default_liquidation_period = fields.Integer('Default Liquidation Period',
            required=True, help='In days')
    week_hours_work = fields.Integer('Week Hours Work', required=True,
            help='In hours')
    default_journal = fields.Many2One('account.journal', 'Default Journal',
            required=True)
