#This file is part of Tryton.  The COPYRIGHT file at the top level of
#this repository contains the full copyright notices and license terms.
from trytond.pool import Pool
from .period import *
from .wage_type import *
from .payroll import *
from .category import *
from .employee import *
from .configuration import *
from .position import *


def register():
    Pool.register(
        Position,
        WorkdayDefinition,
        Period,
        WageType,
        MandatoryWage,
        EmployeeCategory,
        Employee,
        Payroll,
        PayrollLine,
        CategoryWagesDefault,
        PayrollGroupStart,
        PayrollConfiguration,
        WageTypeSalary,
        Move,
        module='staff_payroll', type_='model')
    Pool.register(
        PayrollReport,
        module='staff_payroll', type_='report')
    Pool.register(
        PayrollGroup,
        CreateMandatoryWages,
        PayrollPreliquidation,
        module='staff_payroll', type_='wizard')
