#This file is part of Tryton.  The COPYRIGHT file at the top level of
#this repository contains the full copyright notices and license terms.
from decimal import Decimal
from trytond.pool import PoolMeta

__all__ = ['WageType']
__metaclass__ = PoolMeta


class WageType:
    __name__ = 'staff.wage_type'

    @classmethod
    def __setup__(cls):
        super(WageType, cls).__setup__()
        cls._error_messages.update({
            'no_base_salary': ('The employee does not have base salary!'),
        })
        new_sel = [
                ('health', 'Health'),
                ('retirement', 'Retirement'),
                ('risk', 'Risk'),
                ('box_family', 'Box Family'),
                ('commission', 'Commission'),
                ('bonus_service', 'Bonus Service'),
                ('food', 'Food'),
                ('unemployment', 'Unemployment'),
                ('allowance', 'Allowance'),
                ('transport', 'Transport'),
                ('interest', 'Interest'),
                ('bonus', 'Bonus'),
                ('tax', 'Tax'),
                ('holidays', 'Holidays'),
        ]
        if new_sel not in cls.type_concept.selection:
            cls.type_concept.selection.extend(new_sel)   

    @classmethod
    def validate(cls, wage_types):
        for wage in wage_types:
            test_salary = {'salary': 1000, 'base_salary':1000}
            if wage.unit_price_formula:
                wage.compute_unit_price(test_salary)
            if wage.expense_formula:
                wage.compute_expense(test_salary)

    def compute_unit_price(self, args):
        return self.compute_formula('unit_price_formula', args)

    def compute_formula(self, formula, args=None):
        '''
        This sentence compute a formula field with a salary
        :return: A decimal
        '''
        formula = getattr(self, formula)
        if not formula:
            return Decimal('0')
        if args.get('salary') != None:
            salary = float(args['salary'])
        if args.get('base_salary') != None:
            base_salary = float(args['base_salary'])
        elif 'base_salary' in formula and not args.get('base_salary'):
            self.raise_user_error('no_base_salary',)

        try:
            value = Decimal(str(round(eval(formula), 2)))
            return value
        except Exception:
            self.raise_user_error('invalid_formula', formula)
