#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Copyright (c) 2014 TUNE, Inc.
#  All rights reserved.
#
#  Permission is hereby granted, free of charge, to any person obtaining a copy
#  of this software and associated documentation files (the "Software"), to deal
#  in the Software without restriction, including without limitation the rights
#  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#  copies of the Software, and to permit persons to whom the Software is
#  furnished to do so, subject to the following conditions:
#
#  The above copyright notice and this permission notice shall be included in
#  all copies or substantial portions of the Software.
#
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#  FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE
#  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
#  THE SOFTWARE.
#
#  Python 2.7
#
#  @category  Tune_Reporting
#  @package   Tune_Reporting_Python
#  @author    Jeff Tanner <jefft@tune.com>
#  @copyright 2014 TUNE, Inc. (http://www.tune.com)
#  @license   http://opensource.org/licenses/MIT The MIT License (MIT)
#  @version   $Date: 2014-12-31 17:01:21 $
#  @link      https://developers.mobileapptracking.com/tune-reporting-sdks @endlink
#

import datetime
import os.path
import sys
import traceback

try:
    from tune_reporting import (
        SdkConfig
        )
except ImportError as exc:
    sys.stderr.write("Error: failed to import module ({})".format(exc))
    raise

from example_advertiser_report_actuals import ExampleAdvertiserReportActuals
from example_advertiser_report_cohort_value import ExampleAdvertiserReportCohortValue
from example_advertiser_report_cohort_retention import ExampleAdvertiserReportCohortRetention

from example_advertiser_report_log_clicks import ExampleAdvertiserReportLogClicks
from example_advertiser_report_log_event_items import ExampleAdvertiserReportLogEventItems
from example_advertiser_report_log_events import ExampleAdvertiserReportLogEvents
from example_advertiser_report_log_installs import ExampleAdvertiserReportLogInstalls
from example_advertiser_report_log_postbacks import ExampleAdvertiserReportLogPostbacks

if __name__ == '__main__':
    try:
        if len(sys.argv) < 2:
            raise ValueError(
                "Provide API Key to execute TUNE Advertiser Reporting examples {}.".format(sys.argv[0])
                )

        api_key = sys.argv[1]

        example = ExampleAdvertiserReportActuals()
        example.run(api_key)

        example = ExampleAdvertiserReportCohortValue()
        example.run(api_key)

        example = ExampleAdvertiserReportCohortRetention()
        example.run(api_key)

        example = ExampleAdvertiserReportLogClicks()
        example.run(api_key)

        example = ExampleAdvertiserReportLogEventItems()
        example.run(api_key)

        example = ExampleAdvertiserReportLogEvents()
        example.run(api_key)

        example = ExampleAdvertiserReportLogInstalls()
        example.run(api_key)

        example = ExampleAdvertiserReportLogPostbacks()
        example.run(api_key)

    except Exception as exc:
        print("Exception: {0}".format(exc))
        raise
