##################################################################################
# The MIT License - turboengine
#
# Copyright (c) Oct 2010 Luis C. Cruz <carlitos.kyo@gmail.com>
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
##################################################################################

''' Simple wrap of ZSI to use into GAE.

Please to see how to use webservices on GAE visit this: 
   http://carlitos-kyo.blogspot.com/2009/12/web-services-python-google-app-engine.html
but instead of use ZSI use turboengine wraps:
   from turboengine.webservices import application
to use WSGIAplication and SOAPAplication and send a delete object that serves services.

Requirements:
    * ZSI
    * zope.interface

Common file structure to bind with app.py

..

        from turboengine.webservices.application import SOAPAplication
        from turboengine.webservices.application import WSGIAplication
        
        from EchoServer_server import * # this class is generated by 'python wsdl2py SimpleEcho.wsdl' see http://carlitos-kyo.blogspot.com/2009/12/web-services-python-google-app-engine.html
        
        # Implementing services

        class wsEchoServer(EchoServer):
            # Make WSDL available for HTTP GET
            wsdl = "".join(open('SimpleEcho.wsdl').readlines())
            disco = "".join(open('SimpleEcho.disco').readlines())
              
            def soap_Echo(self, ps, **kw):
                request, response = EchoServer.soap_Echo(self, ps, **kw)
                return request, request 
        
        def main():
            application = WSGIApplication()
            application['EchoServer.asmx'] = SOAPAplication(wsEchoServer())
            #application['OtherServer.asmx'] = SOAPAplication(wsOtherServer()) # could have many webservices
            run_wsgi_app(application)
        
        if __name__ == '__main__':
            main()
'''



