#!/usr/bin/env python
#
# Copyright 2013 Hewlett-Packard Development Company, L.P.
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

"""The Tuskar Service API."""

import logging
import sys
from wsgiref import simple_server

from oslo.config import cfg

from tuskar.api import app
from tuskar.common import service as tuskar_service
from tuskar.openstack.common import log


def main(argv=None):

    if argv is None:
        argv = sys.argv

    tuskar_service.prepare_service(argv)

    # Build and start the WSGI app
    host = cfg.CONF.tuskar_api_bind_ip
    port = cfg.CONF.tuskar_api_port
    wsgi = simple_server.make_server(
        host, port,
        app.VersionSelectorApplication())

    LOG = log.getLogger(__name__)
    LOG.info("Serving on http://%s:%s" % (host, port))
    LOG.info("Configuration:")
    cfg.CONF.log_opt_values(LOG, logging.INFO)

    try:
        wsgi.serve_forever()
    except KeyboardInterrupt:
        pass
