import os
import sys

from setuptools import setup, find_packages

execfile(os.path.join("tw", "starrating", "release.py"))

setup(
    name=__DISTRIBUTION__,
    version=__VERSION__,
    description=__DESCRIPTION__,
    author=__AUTHOR__,
    author_email=__EMAIL__,
    url=__URL__,
    install_requires=[
        "ToscaWidgets>=0.8",
        "tw.forms",
        "tw.jquery",
        ],
    dependency_links=[
        # RuleDispatch 0.5 for python 2.5
        "http://peak.telecommunity.com/snapshots/",
    ],
    packages=find_packages(exclude=['ez_setup', 'tests']),
    namespace_packages = ['tw'],
    zip_safe=False,
    include_package_data=True,
    test_suite = 'nose.collector',
    entry_points="""
        [toscawidgets.widgets]
        # Register your widgets so they can be listed in the WidgetBrowser
        widgets = tw.starrating
        samples = tw.starrating.samples
    """,
    keywords = [
        'toscawidgets.widgets',
    ],
    classifiers = [
        'Development Status :: 3 - Alpha',
        'Environment :: Web Environment',
        'Environment :: Web Environment :: ToscaWidgets',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: Software Development :: Widget Sets',
        'Intended Audience :: Developers',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
    ],
)
