from django.utils.translation import ugettext_lazy as _
# ISO 3166-1 country names and codes adapted from http://opencountrycodes.appspot.com/python/
CONTINENTS = [
    (u'africa', _(u'Africa')),
    (u'antarctica', _(u'Antarctica')),
    (u'asia', _(u'Asia')),
    (u'europe', _(u'Europe')),
    (u'north-america', _(u'North America')),
    (u'oceania', _(u'Oceania')),
    (u'south-america', _(u'South America')),
]

COUNTRIES = (
    (u'GB', _(u'United Kingdom')),
    (u'AF', _(u'Afghanistan')),
    (u'AX', _(u'Aland Islands')),
    (u'AL', _(u'Albania')),
    (u'DZ', _(u'Algeria')),
    (u'AS', _(u'American Samoa')),
    (u'AD', _(u'Andorra')),
    (u'AO', _(u'Angola')),
    (u'AI', _(u'Anguilla')),
    (u'AQ', _(u'Antarctica')),
    (u'AG', _(u'Antigua and Barbuda')),
    (u'AR', _(u'Argentina')),
    (u'AM', _(u'Armenia')),
    (u'AW', _(u'Aruba')),
    (u'AU', _(u'Australia')),
    (u'AT', _(u'Austria')),
    (u'AZ', _(u'Azerbaijan')),
    (u'BS', _(u'Bahamas')),
    (u'BH', _(u'Bahrain')),
    (u'BD', _(u'Bangladesh')),
    (u'BB', _(u'Barbados')),
    (u'BY', _(u'Belarus')),
    (u'BE', _(u'Belgium')),
    (u'BZ', _(u'Belize')),
    (u'BJ', _(u'Benin')),
    (u'BM', _(u'Bermuda')),
    (u'BT', _(u'Bhutan')),
    (u'BO', _(u'Bolivia')),
    (u'BA', _(u'Bosnia and Herzegovina')),
    (u'BW', _(u'Botswana')),
    (u'BV', _(u'Bouvet Island')),
    (u'BR', _(u'Brazil')),
    (u'IO', _(u'British Indian Ocean Territory')),
    (u'BN', _(u'Brunei Darussalam')),
    (u'BG', _(u'Bulgaria')),
    (u'BF', _(u'Burkina Faso')),
    (u'BI', _(u'Burundi')),
    (u'KH', _(u'Cambodia')),
    (u'CM', _(u'Cameroon')),
    (u'CA', _(u'Canada')),
    (u'CV', _(u'Cape Verde')),
    (u'KY', _(u'Cayman Islands')),
    (u'CF', _(u'Central African Republic')),
    (u'TD', _(u'Chad')),
    (u'CL', _(u'Chile')),
    (u'CN', _(u'China')),
    (u'CX', _(u'Christmas Island')),
    (u'CC', _(u'Cocos (Keeling) Islands')),
    (u'CO', _(u'Colombia')),
    (u'KM', _(u'Comoros')),
    (u'CG', _(u'Congo')),
    (u'CD', _(u'Congo, The Democratic Republic of the')),
    (u'CK', _(u'Cook Islands')),
    (u'CR', _(u'Costa Rica')),
    (u'CI', _(u'Cote d\'Ivoire')),
    (u'HR', _(u'Croatia')),
    (u'CU', _(u'Cuba')),
    (u'CY', _(u'Cyprus')),
    (u'CZ', _(u'Czech Republic')),
    (u'DK', _(u'Denmark')),
    (u'DJ', _(u'Djibouti')),
    (u'DM', _(u'Dominica')),
    (u'DO', _(u'Dominican Republic')),
    (u'EC', _(u'Ecuador')),
    (u'EG', _(u'Egypt')),
    (u'SV', _(u'El Salvador')),
    (u'GQ', _(u'Equatorial Guinea')),
    (u'ER', _(u'Eritrea')),
    (u'EE', _(u'Estonia')),
    (u'ET', _(u'Ethiopia')),
    (u'FK', _(u'Falkland Islands (Malvinas)')),
    (u'FO', _(u'Faroe Islands')),
    (u'FJ', _(u'Fiji')),
    (u'FI', _(u'Finland')),
    (u'FR', _(u'France')),
    (u'GF', _(u'French Guiana')),
    (u'PF', _(u'French Polynesia')),
    (u'TF', _(u'French Southern Territories')),
    (u'GA', _(u'Gabon')),
    (u'GM', _(u'Gambia')),
    (u'GE', _(u'Georgia')),
    (u'DE', _(u'Germany')),
    (u'GH', _(u'Ghana')),
    (u'GI', _(u'Gibraltar')),
    (u'GR', _(u'Greece')),
    (u'GL', _(u'Greenland')),
    (u'GD', _(u'Grenada')),
    (u'GP', _(u'Guadeloupe')),
    (u'GU', _(u'Guam')),
    (u'GT', _(u'Guatemala')),
    (u'GG', _(u'Guernsey')),
    (u'GN', _(u'Guinea')),
    (u'GW', _(u'Guinea-Bissau')),
    (u'GY', _(u'Guyana')),
    (u'HT', _(u'Haiti')),
    (u'HM', _(u'Heard Island and McDonald Islands')),
    (u'VA', _(u'Holy See (Vatican City State)')),
    (u'HN', _(u'Honduras')),
    (u'HK', _(u'Hong Kong')),
    (u'HU', _(u'Hungary')),
    (u'IS', _(u'Iceland')),
    (u'IN', _(u'India')),
    (u'ID', _(u'Indonesia')),
    (u'IR', _(u'Iran, Islamic Republic of')),
    (u'IQ', _(u'Iraq')),
    (u'IE', _(u'Ireland')),
    (u'IM', _(u'Isle of Man')),
    (u'IL', _(u'Israel')),
    (u'IT', _(u'Italy')),
    (u'JM', _(u'Jamaica')),
    (u'JP', _(u'Japan')),
    (u'JE', _(u'Jersey')),
    (u'JO', _(u'Jordan')),
    (u'KZ', _(u'Kazakhstan')),
    (u'KE', _(u'Kenya')),
    (u'KI', _(u'Kiribati')),
    (u'KP', _(u'Korea, Democratic People\'s Republic of')),
    (u'KR', _(u'Korea, Republic of')),
    (u'KW', _(u'Kuwait')),
    (u'KG', _(u'Kyrgyzstan')),
    (u'LA', _(u'Lao People\'s Democratic Republic')),
    (u'LV', _(u'Latvia')),
    (u'LB', _(u'Lebanon')),
    (u'LS', _(u'Lesotho')),
    (u'LR', _(u'Liberia')),
    (u'LY', _(u'Libyan Arab Jamahiriya')),
    (u'LI', _(u'Liechtenstein')),
    (u'LT', _(u'Lithuania')),
    (u'LU', _(u'Luxembourg')),
    (u'MO', _(u'Macao')),
    (u'MK', _(u'Macedonia, The Former Yugoslav Republic of')),
    (u'MG', _(u'Madagascar')),
    (u'MW', _(u'Malawi')),
    (u'MY', _(u'Malaysia')),
    (u'MV', _(u'Maldives')),
    (u'ML', _(u'Mali')),
    (u'MT', _(u'Malta')),
    (u'MH', _(u'Marshall Islands')),
    (u'MQ', _(u'Martinique')),
    (u'MR', _(u'Mauritania')),
    (u'MU', _(u'Mauritius')),
    (u'YT', _(u'Mayotte')),
    (u'MX', _(u'Mexico')),
    (u'FM', _(u'Micronesia, Federated States of')),
    (u'MD', _(u'Moldova')),
    (u'MC', _(u'Monaco')),
    (u'MN', _(u'Mongolia')),
    (u'ME', _(u'Montenegro')),
    (u'MS', _(u'Montserrat')),
    (u'MA', _(u'Morocco')),
    (u'MZ', _(u'Mozambique')),
    (u'MM', _(u'Myanmar')),
    (u'NA', _(u'Namibia')),
    (u'NR', _(u'Nauru')),
    (u'NP', _(u'Nepal')),
    (u'NL', _(u'Netherlands')),
    (u'AN', _(u'Netherlands Antilles')),
    (u'NC', _(u'New Caledonia')),
    (u'NZ', _(u'New Zealand')),
    (u'NI', _(u'Nicaragua')),
    (u'NE', _(u'Niger')),
    (u'NG', _(u'Nigeria')),
    (u'NU', _(u'Niue')),
    (u'NF', _(u'Norfolk Island')),
    (u'MP', _(u'Northern Mariana Islands')),
    (u'NO', _(u'Norway')),
    (u'OM', _(u'Oman')),
    (u'PK', _(u'Pakistan')),
    (u'PW', _(u'Palau')),
    (u'PS', _(u'Palestinian Territory, Occupied')),
    (u'PA', _(u'Panama')),
    (u'PG', _(u'Papua New Guinea')),
    (u'PY', _(u'Paraguay')),
    (u'PE', _(u'Peru')),
    (u'PH', _(u'Philippines')),
    (u'PN', _(u'Pitcairn')),
    (u'PL', _(u'Poland')),
    (u'PT', _(u'Portugal')),
    (u'PR', _(u'Puerto Rico')),
    (u'QA', _(u'Qatar')),
    (u'RE', _(u'Reunion')),
    (u'RO', _(u'Romania')),
    (u'RU', _(u'Russian Federation')),
    (u'RW', _(u'Rwanda')),
    (u'BL', _(u'Saint Barthelemy')),
    (u'SH', _(u'Saint Helena')),
    (u'KN', _(u'Saint Kitts and Nevis')),
    (u'LC', _(u'Saint Lucia')),
    (u'MF', _(u'Saint Martin')),
    (u'PM', _(u'Saint Pierre and Miquelon')),
    (u'VC', _(u'Saint Vincent and the Grenadines')),
    (u'WS', _(u'Samoa')),
    (u'SM', _(u'San Marino')),
    (u'ST', _(u'Sao Tome and Principe')),
    (u'SA', _(u'Saudi Arabia')),
    (u'SN', _(u'Senegal')),
    (u'RS', _(u'Serbia')),
    (u'SC', _(u'Seychelles')),
    (u'SL', _(u'Sierra Leone')),
    (u'SG', _(u'Singapore')),
    (u'SK', _(u'Slovakia')),
    (u'SI', _(u'Slovenia')),
    (u'SB', _(u'Solomon Islands')),
    (u'SO', _(u'Somalia')),
    (u'ZA', _(u'South Africa')),
    (u'GS', _(u'South Georgia and the South Sandwich Islands')),
    (u'ES', _(u'Spain')),
    (u'LK', _(u'Sri Lanka')),
    (u'SD', _(u'Sudan')),
    (u'SR', _(u'Suriname')),
    (u'SJ', _(u'Svalbard and Jan Mayen')),
    (u'SZ', _(u'Swaziland')),
    (u'SE', _(u'Sweden')),
    (u'CH', _(u'Switzerland')),
    (u'SY', _(u'Syrian Arab Republic')),
    (u'TW', _(u'Taiwan, Province of China')),
    (u'TJ', _(u'Tajikistan')),
    (u'TZ', _(u'Tanzania, United Republic of')),
    (u'TH', _(u'Thailand')),
    (u'TL', _(u'Timor-Leste')),
    (u'TG', _(u'Togo')),
    (u'TK', _(u'Tokelau')),
    (u'TO', _(u'Tonga')),
    (u'TT', _(u'Trinidad and Tobago')),
    (u'TN', _(u'Tunisia')),
    (u'TR', _(u'Turkey')),
    (u'TM', _(u'Turkmenistan')),
    (u'TC', _(u'Turks and Caicos Islands')),
    (u'TV', _(u'Tuvalu')),
    (u'UG', _(u'Uganda')),
    (u'UA', _(u'Ukraine')),
    (u'AE', _(u'United Arab Emirates')),
    (u'US', _(u'United States')),
    (u'UM', _(u'United States Minor Outlying Islands')),
    (u'UY', _(u'Uruguay')),
    (u'UZ', _(u'Uzbekistan')),
    (u'VU', _(u'Vanuatu')),
    (u'VE', _(u'Venezuela')),
    (u'VN', _(u'Viet Nam')),
    (u'VG', _(u'Virgin Islands, British')),
    (u'VI', _(u'Virgin Islands, U.S.')),
    (u'WF', _(u'Wallis and Futuna')),
    (u'EH', _(u'Western Sahara')),
    (u'YE', _(u'Yemen')),
    (u'ZM', _(u'Zambia')),
    (u'ZW', _(u'Zimbabwe')),
)

CONTINENT_COUNTRIES = (
    (_(u'Africa'), (
        (u'DZ', _(u'Algeria')),
        (u'AO', _(u'Angola')),
        (u'BJ', _(u'Benin')),
        (u'BW', _(u'Botswana')),
        (u'BF', _(u'Burkina Faso')),
        (u'BI', _(u'Burundi')),
        (u'CM', _(u'Cameroon')),
        (u'CV', _(u'Cape Verde')),
        (u'CF', _(u'Central African Republic')),
        (u'TD', _(u'Chad')),
        (u'KM', _(u'Comoros')),
        (u'CG', _(u'Congo')),
        (u'CD', _(u'Congo, The Democratic Republic of the')),
        (u'CI', _(u'Cote d\'Ivoire')),
        (u'DJ', _(u'Djibouti')),
        (u'EG', _(u'Egypt')),
        (u'GQ', _(u'Equatorial Guinea')),
        (u'ER', _(u'Eritrea')),
        (u'ET', _(u'Ethiopia')),
        (u'GA', _(u'Gabon')),
        (u'GM', _(u'Gambia')),
        (u'GH', _(u'Ghana')),
        (u'GN', _(u'Guinea')),
        (u'GW', _(u'Guinea-Bissau')),
        (u'KE', _(u'Kenya')),
        (u'LS', _(u'Lesotho')),
        (u'LR', _(u'Liberia')),
        (u'LY', _(u'Libyan Arab Jamahiriya')),
        (u'MG', _(u'Madagascar')),
        (u'YT', _(u'Mayotte')),
        (u'MW', _(u'Malawi')),
        (u'ML', _(u'Mali')),
        (u'MR', _(u'Mauritania')),
        (u'MU', _(u'Mauritius')),
        (u'MA', _(u'Morocco')),
        (u'MZ', _(u'Mozambique')),
        (u'NA', _(u'Namibia')),
        (u'NE', _(u'Niger')),
        (u'NG', _(u'Nigeria')),
        (u'RE', _(u'Reunion')),
        (u'RW', _(u'Rwanda')),
        (u'SH', _(u'Saint Helena')),
        (u'ST', _(u'Sao Tome and Principe')),
        (u'SN', _(u'Senegal')),
        (u'SC', _(u'Seychelles')),
        (u'SL', _(u'Sierra Leone')),
        (u'SO', _(u'Somalia')),
        (u'ZA', _(u'South Africa')),
        (u'SD', _(u'Sudan')),
        (u'SZ', _(u'Swaziland')),
        (u'TZ', _(u'Tanzania, United Republic of')),
        (u'TG', _(u'Togo')),
        (u'TN', _(u'Tunisia')),
        (u'UG', _(u'Uganda')),
        (u'EH', _(u'Western Sahara')),
        (u'ZM', _(u'Zambia')),
        (u'ZW', _(u'Zimbabwe')),
    )),
    (_(u'Antarctica'), (
        (u'AQ', _(u'Antarctica')),
        (u'BV', _(u'Bouvet Island')),
        (u'TF', _(u'French Southern Territories')),
        (u'HM', _(u'Heard Island and McDonald Islands')),
    )),
    (_(u'Asia'), (
        (u'AF', _(u'Afghanistan')),
        (u'BH', _(u'Bahrain')),
        (u'BD', _(u'Bangladesh')),
        (u'BT', _(u'Bhutan')),
        (u'IO', _(u'British Indian Ocean Territory')),
        (u'BN', _(u'Brunei Darussalam')),
        (u'KH', _(u'Cambodia')),
        (u'CN', _(u'China')),
        (u'HK', _(u'Hong Kong')),
        (u'IR', _(u'Iran, Islamic Republic of')),
        (u'IN', _(u'India')),
        (u'ID', _(u'Indonesia')),
        (u'IQ', _(u'Iraq')),
        (u'IL', _(u'Israel')),
        (u'JP', _(u'Japan')),
        (u'JO', _(u'Jordan')),
        (u'KZ', _(u'Kazakhstan')),
        (u'KW', _(u'Kuwait')),
        (u'KP', _(u'Korea, Democratic People\'s Republic of')),
        (u'KR', _(u'Korea, Republic of')),
        (u'LA', _(u'Lao People\'s Democratic Republic')),
        (u'KG', _(u'Kyrgyzstan')),
        (u'LB', _(u'Lebanon')),
        (u'MO', _(u'Macao')),
        (u'MY', _(u'Malaysia')),
        (u'MV', _(u'Maldives')),
        (u'MM', _(u'Myanmar')),
        (u'MN', _(u'Mongolia')),
        (u'NP', _(u'Nepal')),
        (u'OM', _(u'Oman')),
        (u'PK', _(u'Pakistan')),
        (u'PS', _(u'Palestinian Territory, Occupied')),
        (u'PH', _(u'Philippines')),
        (u'QA', _(u'Qatar')),
        (u'RU', _(u'Russian Federation')),
        (u'SA', _(u'Saudi Arabia')),
        (u'SG', _(u'Singapore')),
        (u'SY', _(u'Syrian Arab Republic')),
        (u'LK', _(u'Sri Lanka')),
        (u'TJ', _(u'Tajikistan')),
        (u'TW', _(u'Taiwan, Province of China')),
        (u'TH', _(u'Thailand')),
        (u'TL', _(u'Timor-Leste')),
        (u'TR', _(u'Turkey')),
        (u'TM', _(u'Turkmenistan')),
        (u'AE', _(u'United Arab Emirates')),
        (u'UZ', _(u'Uzbekistan')),
        (u'VN', _(u'Vietnam')),
        (u'YE', _(u'Yemen')),
    )),
    (_(u'Europe'), (
        (u'AX', _(u'Aland Islands')),
        (u'AL', _(u'Albania')),
        (u'AD', _(u'Andorra')),
        (u'AM', _(u'Armenia')),
        (u'AT', _(u'Austria')),
        (u'AZ', _(u'Azerbaijan')),
        (u'BY', _(u'Belarus')),
        (u'BE', _(u'Belgium')),
        (u'BA', _(u'Bosnia and Herzegovina')),
        (u'BG', _(u'Bulgaria')),
        (u'HR', _(u'Croatia')),
        (u'CY', _(u'Cyprus')),
        (u'CZ', _(u'Czech Republic')),
        (u'DK', _(u'Denmark')),
        (u'EE', _(u'Estonia')),
        (u'FO', _(u'Faroe Islands')),
        (u'FI', _(u'Finland')),
        (u'FR', _(u'France')),
        (u'GE', _(u'Georgia')),
        (u'DE', _(u'Germany')),
        (u'GI', _(u'Gibraltar')),
        (u'GR', _(u'Greece')),
        (u'GL', _(u'Greenland')),
        (u'GG', _(u'Guernsey')),
        (u'HU', _(u'Hungary')),
        (u'IS', _(u'Iceland')),
        (u'IE', _(u'Ireland')),
        (u'IM', _(u'Isle of Man')),
        (u'IT', _(u'Italy')),
        (u'JE', _(u'Jersey')),
        (u'LV', _(u'Latvia')),
        (u'LI', _(u'Liechtenstein')),
        (u'LT', _(u'Lithuania')),
        (u'LU', _(u'Luxembourg')),
        (u'MK', _(u'Macedonia, The Former Yugoslav Republic of')),
        (u'MT', _(u'Malta')),
        (u'MD', _(u'Moldova')),
        (u'MC', _(u'Monaco')),
        (u'ME', _(u'Montenegro')),
        (u'NL', _(u'Netherlands')),
        (u'NO', _(u'Norway')),
        (u'PL', _(u'Poland')),
        (u'PT', _(u'Portugal')),
        (u'RO', _(u'Romania')),
        (u'SM', _(u'San Marino')),
        (u'RS', _(u'Serbia')),
        (u'SK', _(u'Slovakia')),
        (u'SI', _(u'Slovenia')),
        (u'ES', _(u'Spain')),
        (u'SJ', _(u'Svalbard and Jan Mayen')),
        (u'SE', _(u'Sweden')),
        (u'CH', _(u'Switzerland')),
        (u'UA', _(u'Ukraine')),
        (u'GB', _(u'United Kingdom')),
        (u'VA', _(u'Holy See (Vatican City State)')),
    )),
    (_(u'North America'), (
        (u'AS', _(u'American Samoa')),
        (u'AI', _(u'Anguilla')),
        (u'AG', _(u'Antigua and Barbuda')),
        (u'AW', _(u'Aruba')),
        (u'BS', _(u'Bahamas')),
        (u'BB', _(u'Barbados')),
        (u'BZ', _(u'Belize')),
        (u'BM', _(u'Bermuda')),
        (u'CA', _(u'Canada')),
        (u'KY', _(u'Cayman Islands')),
        (u'CR', _(u'Costa Rica')),
        (u'CU', _(u'Cuba')),
        (u'DM', _(u'Dominica')),
        (u'DO', _(u'Dominican Republic')),
        (u'SV', _(u'El Salvador')),
        (u'GD', _(u'Grenada')),
        (u'GP', _(u'Guadeloupe')),
        (u'GT', _(u'Guatemala')),
        (u'HT', _(u'Haiti')),
        (u'HN', _(u'Honduras')),
        (u'JM', _(u'Jamaica')),
        (u'MX', _(u'Mexico')),
        (u'MS', _(u'Montserrat')),
        (u'AN', _(u'Netherlands Antilles')),
        (u'NI', _(u'Nicaragua')),
        (u'PA', _(u'Panama')),
        (u'PR', _(u'Puerto Rico')),
        (u'BL', _(u'Saint Barthelemy')),
        (u'KN', _(u'Saint Kitts and Nevis')),
        (u'LC', _(u'Saint Lucia')),
        (u'MF', _(u'Saint Martin')),
        (u'PM', _(u'Saint Pierre and Miquelon')),
        (u'VC', _(u'Saint Vincent and the Grenadines')),
        (u'TT', _(u'Trinidad and Tobago')),
        (u'TC', _(u'Turks and Caicos Islands')),
        (u'US', _(u'United States')),
        (u'UM', _(u'United States Minor Outlying Islands')),
        (u'VG', _(u'Virgin Islands, British')),
        (u'VI', _(u'Virgin Islands, U.S.')),
    )),
    (_(u'Oceania'), (
        (u'AU', _(u'Australia')),
        (u'CX', _(u'Christmas Island')),
        (u'CC', _(u'Cocos (Keeling) Islands')),
        (u'CK', _(u'Cook Islands')),
        (u'FJ', _(u'Fiji')),
        (u'PF', _(u'French Polynesia')),
        (u'GU', _(u'Guam')),
        (u'KI', _(u'Kiribati')),
        (u'MH', _(u'Marshall Islands')),
        (u'FM', _(u'Micronesia, Federated States of')),
        (u'NR', _(u'Nauru')),
        (u'NC', _(u'New Caledonia')),
        (u'NZ', _(u'New Zealand')),
        (u'NU', _(u'Niue')),
        (u'NF', _(u'Norfolk Island')),
        (u'MP', _(u'Northern Mariana Islands')),
        (u'PW', _(u'Palau')),
        (u'PG', _(u'Papua New Guinea')),
        (u'PN', _(u'Pitcairn')),
        (u'WS', _(u'Samoa')),
        (u'SB', _(u'Solomon Islands')),
        (u'TK', _(u'Tokelau')),
        (u'TO', _(u'Tonga')),
        (u'TV', _(u'Tuvalu')),
        (u'VU', _(u'Vanuatu')),
        (u'WF', _(u'Wallis and Futuna')),
    )),
    (_(u'South America'), (
        (u'AR', _(u'Argentina')),
        (u'BO', _(u'Bolivia')),
        (u'BR', _(u'Brazil')),
        (u'CL', _(u'Chile')),
        (u'CO', _(u'Colombia')),
        (u'EC', _(u'Ecuador')),
        (u'FK', _(u'Falkland Islands (Malvinas)')),
        (u'GF', _(u'French Guiana')),
        (u'GY', _(u'Guyana')),
        (u'MQ', _(u'Martinique')),
        (u'PY', _(u'Paraguay')),
        (u'PE', _(u'Peru')),
        (u'GS', _(u'South Georgia and the South Sandwich Islands')),
        (u'SR', _(u'Suriname')),
        (u'UY', _(u'Uruguay')),
        (u'VE', _(u'Venezuela')),
    )
    ),
)

