
#include <Python.h>
#include <stddef.h>

#ifdef MS_WIN32
#include <malloc.h>   /* for alloca() */
typedef __int8 int8_t;
typedef __int16 int16_t;
typedef __int32 int32_t;
typedef __int64 int64_t;
typedef unsigned __int8 uint8_t;
typedef unsigned __int16 uint16_t;
typedef unsigned __int32 uint32_t;
typedef unsigned __int64 uint64_t;
typedef unsigned char _Bool;
#endif

#if PY_MAJOR_VERSION < 3
# undef PyCapsule_CheckExact
# undef PyCapsule_GetPointer
# define PyCapsule_CheckExact(capsule) (PyCObject_Check(capsule))
# define PyCapsule_GetPointer(capsule, name) \
    (PyCObject_AsVoidPtr(capsule))
#endif

#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_SIGNED(x, type)                                     \
    (sizeof(type) <= sizeof(long) ? PyInt_FromLong(x) :                  \
                                    PyLong_FromLongLong(x))
#define _cffi_from_c_UNSIGNED(x, type)                                   \
    (sizeof(type) < sizeof(long) ? PyInt_FromLong(x) :                   \
     sizeof(type) == sizeof(long) ? PyLong_FromUnsignedLong(x) :         \
                                    PyLong_FromUnsignedLongLong(x))

#define _cffi_to_c_SIGNED(o, type)                                       \
    (sizeof(type) == 1 ? _cffi_to_c_i8(o) :                              \
     sizeof(type) == 2 ? _cffi_to_c_i16(o) :                             \
     sizeof(type) == 4 ? _cffi_to_c_i32(o) :                             \
     sizeof(type) == 8 ? _cffi_to_c_i64(o) :                             \
     (Py_FatalError("unsupported size for type " #type), 0))
#define _cffi_to_c_UNSIGNED(o, type)                                     \
    (sizeof(type) == 1 ? _cffi_to_c_u8(o) :                              \
     sizeof(type) == 2 ? _cffi_to_c_u16(o) :                             \
     sizeof(type) == 4 ? _cffi_to_c_u32(o) :                             \
     sizeof(type) == 8 ? _cffi_to_c_u64(o) :                             \
     (Py_FatalError("unsupported size for type " #type), 0))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, CTypeDescrObject *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, CTypeDescrObject *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    ((PyObject *(*)(Py_ssize_t[]))_cffi_exports[12])
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, CTypeDescrObject *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, CTypeDescrObject *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, CTypeDescrObject *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(CTypeDescrObject *, PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, CTypeDescrObject *, PyObject *))_cffi_exports[24])
#define _CFFI_NUM_EXPORTS 25

typedef struct _ctypedescr CTypeDescrObject;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];
static PyObject *_cffi_types, *_cffi_VerificationError;

static PyObject *_cffi_setup_custom(PyObject *lib);   /* forward */

static PyObject *_cffi_setup(PyObject *self, PyObject *args)
{
    PyObject *library;
    if (!PyArg_ParseTuple(args, "OOO", &_cffi_types, &_cffi_VerificationError,
                                       &library))
        return NULL;
    Py_INCREF(_cffi_types);
    Py_INCREF(_cffi_VerificationError);
    return _cffi_setup_custom(library);
}

static void _cffi_init(void)
{
    PyObject *module = PyImport_ImportModule("_cffi_backend");
    PyObject *c_api_object;

    if (module == NULL)
        return;

    c_api_object = PyObject_GetAttrString(module, "_C_API");
    if (c_api_object == NULL)
        return;
    if (!PyCapsule_CheckExact(c_api_object)) {
        PyErr_SetNone(PyExc_ImportError);
        return;
    }
    memcpy(_cffi_exports, PyCapsule_GetPointer(c_api_object, "cffi"),
           _CFFI_NUM_EXPORTS * sizeof(void *));
}

#define _cffi_type(num) ((CTypeDescrObject *)PyList_GET_ITEM(_cffi_types, num))

/**********/



    #include <launch.h>
    

static int _cffi_e__launch_data_type_t(PyObject *lib)
{
  if (LAUNCH_DATA_DICTIONARY != 1) {
    PyErr_Format(_cffi_VerificationError,
                 "enum %s: %s has the real value %d, not %d",
                 "launch_data_type_t", "LAUNCH_DATA_DICTIONARY", (int)LAUNCH_DATA_DICTIONARY, 1);
    return -1;
  }
  if (LAUNCH_DATA_ARRAY != 2) {
    PyErr_Format(_cffi_VerificationError,
                 "enum %s: %s has the real value %d, not %d",
                 "launch_data_type_t", "LAUNCH_DATA_ARRAY", (int)LAUNCH_DATA_ARRAY, 2);
    return -1;
  }
  if (LAUNCH_DATA_FD != 3) {
    PyErr_Format(_cffi_VerificationError,
                 "enum %s: %s has the real value %d, not %d",
                 "launch_data_type_t", "LAUNCH_DATA_FD", (int)LAUNCH_DATA_FD, 3);
    return -1;
  }
  if (LAUNCH_DATA_INTEGER != 4) {
    PyErr_Format(_cffi_VerificationError,
                 "enum %s: %s has the real value %d, not %d",
                 "launch_data_type_t", "LAUNCH_DATA_INTEGER", (int)LAUNCH_DATA_INTEGER, 4);
    return -1;
  }
  if (LAUNCH_DATA_REAL != 5) {
    PyErr_Format(_cffi_VerificationError,
                 "enum %s: %s has the real value %d, not %d",
                 "launch_data_type_t", "LAUNCH_DATA_REAL", (int)LAUNCH_DATA_REAL, 5);
    return -1;
  }
  if (LAUNCH_DATA_BOOL != 6) {
    PyErr_Format(_cffi_VerificationError,
                 "enum %s: %s has the real value %d, not %d",
                 "launch_data_type_t", "LAUNCH_DATA_BOOL", (int)LAUNCH_DATA_BOOL, 6);
    return -1;
  }
  if (LAUNCH_DATA_STRING != 7) {
    PyErr_Format(_cffi_VerificationError,
                 "enum %s: %s has the real value %d, not %d",
                 "launch_data_type_t", "LAUNCH_DATA_STRING", (int)LAUNCH_DATA_STRING, 7);
    return -1;
  }
  if (LAUNCH_DATA_OPAQUE != 8) {
    PyErr_Format(_cffi_VerificationError,
                 "enum %s: %s has the real value %d, not %d",
                 "launch_data_type_t", "LAUNCH_DATA_OPAQUE", (int)LAUNCH_DATA_OPAQUE, 8);
    return -1;
  }
  if (LAUNCH_DATA_ERRNO != 9) {
    PyErr_Format(_cffi_VerificationError,
                 "enum %s: %s has the real value %d, not %d",
                 "launch_data_type_t", "LAUNCH_DATA_ERRNO", (int)LAUNCH_DATA_ERRNO, 9);
    return -1;
  }
  if (LAUNCH_DATA_MACHPORT != 10) {
    PyErr_Format(_cffi_VerificationError,
                 "enum %s: %s has the real value %d, not %d",
                 "launch_data_type_t", "LAUNCH_DATA_MACHPORT", (int)LAUNCH_DATA_MACHPORT, 10);
    return -1;
  }
  return 0;
}

static int _cffi_const_LAUNCH_JOBKEY_LABEL(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (LAUNCH_JOBKEY_LABEL);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "LAUNCH_JOBKEY_LABEL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_e__launch_data_type_t(lib);
}

static int _cffi_const_LAUNCH_JOBKEY_SOCKETS(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (LAUNCH_JOBKEY_SOCKETS);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "LAUNCH_JOBKEY_SOCKETS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_LAUNCH_JOBKEY_LABEL(lib);
}

static int _cffi_const_LAUNCH_KEY_CHECKIN(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (LAUNCH_KEY_CHECKIN);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "LAUNCH_KEY_CHECKIN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_LAUNCH_JOBKEY_SOCKETS(lib);
}

static PyObject *
_cffi_f_launch_data_alloc(PyObject *self, PyObject *arg0)
{
  launch_data_type_t x0;
  struct _launch_data * result;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = launch_data_alloc(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(2));
}

static PyObject *
_cffi_f_launch_data_array_get_count(PyObject *self, PyObject *arg0)
{
  struct _launch_data * x0;
  Py_ssize_t datasize;
  size_t result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(2), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = launch_data_array_get_count(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_UNSIGNED(result, size_t);
}

static PyObject *
_cffi_f_launch_data_array_get_index(PyObject *self, PyObject *args)
{
  struct _launch_data * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _launch_data * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:launch_data_array_get_index", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(2), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_UNSIGNED(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = launch_data_array_get_index(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(2));
}

static PyObject *
_cffi_f_launch_data_array_set_index(PyObject *self, PyObject *args)
{
  struct _launch_data * x0;
  struct _launch_data * x1;
  size_t x2;
  Py_ssize_t datasize;
  _Bool result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:launch_data_array_set_index", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(2), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_UNSIGNED(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = launch_data_array_set_index(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_UNSIGNED(result, _Bool);
}

static PyObject *
_cffi_f_launch_data_dict_get_count(PyObject *self, PyObject *arg0)
{
  struct _launch_data * x0;
  Py_ssize_t datasize;
  size_t result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(2), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = launch_data_dict_get_count(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_UNSIGNED(result, size_t);
}

static PyObject *
_cffi_f_launch_data_dict_insert(PyObject *self, PyObject *args)
{
  struct _launch_data * x0;
  struct _launch_data * x1;
  char const * x2;
  Py_ssize_t datasize;
  _Bool result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:launch_data_dict_insert", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(2), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(0), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = launch_data_dict_insert(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_UNSIGNED(result, _Bool);
}

static PyObject *
_cffi_f_launch_data_dict_iterate(PyObject *self, PyObject *args)
{
  struct _launch_data * x0;
  void(* x1)(struct _launch_data *, char const *, void *);
  void * x2;
  Py_ssize_t datasize;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:launch_data_dict_iterate", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(2), arg0) < 0)
      return NULL;
  }

  x1 = (void(*)(struct _launch_data *, char const *, void *))_cffi_to_c_pointer(arg1, _cffi_type(3));
  if (x1 == (void(*)(struct _launch_data *, char const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(4), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { launch_data_dict_iterate(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_launch_data_dict_lookup(PyObject *self, PyObject *args)
{
  struct _launch_data * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _launch_data * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:launch_data_dict_lookup", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(2), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(0), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = launch_data_dict_lookup(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(2));
}

static PyObject *
_cffi_f_launch_data_free(PyObject *self, PyObject *arg0)
{
  struct _launch_data * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(2), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { launch_data_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_launch_data_get_bool(PyObject *self, PyObject *arg0)
{
  struct _launch_data * x0;
  Py_ssize_t datasize;
  _Bool result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(2), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = launch_data_get_bool(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_UNSIGNED(result, _Bool);
}

static PyObject *
_cffi_f_launch_data_get_fd(PyObject *self, PyObject *arg0)
{
  struct _launch_data * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(2), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = launch_data_get_fd(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_SIGNED(result, int);
}

static PyObject *
_cffi_f_launch_data_get_integer(PyObject *self, PyObject *arg0)
{
  struct _launch_data * x0;
  Py_ssize_t datasize;
  long long result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(2), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = launch_data_get_integer(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_SIGNED(result, long long);
}

static PyObject *
_cffi_f_launch_data_get_real(PyObject *self, PyObject *arg0)
{
  struct _launch_data * x0;
  Py_ssize_t datasize;
  double result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(2), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = launch_data_get_real(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_double(result);
}

static PyObject *
_cffi_f_launch_data_get_string(PyObject *self, PyObject *arg0)
{
  struct _launch_data * x0;
  Py_ssize_t datasize;
  char const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(2), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = launch_data_get_string(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(0));
}

static PyObject *
_cffi_f_launch_data_get_type(PyObject *self, PyObject *arg0)
{
  struct _launch_data * x0;
  Py_ssize_t datasize;
  launch_data_type_t result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(2), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = launch_data_get_type(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_deref((char *)&result, _cffi_type(1));
}

static PyObject *
_cffi_f_launch_data_new_bool(PyObject *self, PyObject *arg0)
{
  _Bool x0;
  struct _launch_data * result;

  x0 = _cffi_to_c__Bool(arg0);
  if (x0 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = launch_data_new_bool(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(2));
}

static PyObject *
_cffi_f_launch_data_new_fd(PyObject *self, PyObject *arg0)
{
  int x0;
  struct _launch_data * result;

  x0 = _cffi_to_c_SIGNED(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = launch_data_new_fd(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(2));
}

static PyObject *
_cffi_f_launch_data_new_integer(PyObject *self, PyObject *arg0)
{
  long long x0;
  struct _launch_data * result;

  x0 = _cffi_to_c_SIGNED(arg0, long long);
  if (x0 == (long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = launch_data_new_integer(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(2));
}

static PyObject *
_cffi_f_launch_data_new_real(PyObject *self, PyObject *arg0)
{
  double x0;
  struct _launch_data * result;

  x0 = _cffi_to_c_double(arg0);
  if (x0 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = launch_data_new_real(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(2));
}

static PyObject *
_cffi_f_launch_data_new_string(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _launch_data * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(0), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = launch_data_new_string(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(2));
}

static PyObject *
_cffi_f_launch_msg(PyObject *self, PyObject *arg0)
{
  struct _launch_data * x0;
  Py_ssize_t datasize;
  struct _launch_data * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(2), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = launch_msg(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(2));
}

static PyObject *_cffi_setup_custom(PyObject *lib)
{
  if (_cffi_const_LAUNCH_KEY_CHECKIN(lib) < 0)
    return NULL;
  Py_INCREF(Py_None);
  return Py_None;
}

static PyMethodDef _cffi_methods[] = {
  {"launch_data_alloc", _cffi_f_launch_data_alloc, METH_O},
  {"launch_data_array_get_count", _cffi_f_launch_data_array_get_count, METH_O},
  {"launch_data_array_get_index", _cffi_f_launch_data_array_get_index, METH_VARARGS},
  {"launch_data_array_set_index", _cffi_f_launch_data_array_set_index, METH_VARARGS},
  {"launch_data_dict_get_count", _cffi_f_launch_data_dict_get_count, METH_O},
  {"launch_data_dict_insert", _cffi_f_launch_data_dict_insert, METH_VARARGS},
  {"launch_data_dict_iterate", _cffi_f_launch_data_dict_iterate, METH_VARARGS},
  {"launch_data_dict_lookup", _cffi_f_launch_data_dict_lookup, METH_VARARGS},
  {"launch_data_free", _cffi_f_launch_data_free, METH_O},
  {"launch_data_get_bool", _cffi_f_launch_data_get_bool, METH_O},
  {"launch_data_get_fd", _cffi_f_launch_data_get_fd, METH_O},
  {"launch_data_get_integer", _cffi_f_launch_data_get_integer, METH_O},
  {"launch_data_get_real", _cffi_f_launch_data_get_real, METH_O},
  {"launch_data_get_string", _cffi_f_launch_data_get_string, METH_O},
  {"launch_data_get_type", _cffi_f_launch_data_get_type, METH_O},
  {"launch_data_new_bool", _cffi_f_launch_data_new_bool, METH_O},
  {"launch_data_new_fd", _cffi_f_launch_data_new_fd, METH_O},
  {"launch_data_new_integer", _cffi_f_launch_data_new_integer, METH_O},
  {"launch_data_new_real", _cffi_f_launch_data_new_real, METH_O},
  {"launch_data_new_string", _cffi_f_launch_data_new_string, METH_O},
  {"launch_msg", _cffi_f_launch_msg, METH_O},
  {"_cffi_setup", _cffi_setup, METH_VARARGS},
  {NULL, NULL}    /* Sentinel */
};

PyMODINIT_FUNC
init_cffi_twext_python_launchd_x71c5fdx5b3668f3(void)
{
  PyObject *lib;
  lib = Py_InitModule("_cffi_twext_python_launchd_x71c5fdx5b3668f3", _cffi_methods);
  if (lib == NULL || 0 < 0)
    return;
  _cffi_init();
  return;
}
