from ez_setup import use_setuptools
use_setuptools()
from setuptools import setup

setup(
    name='uWeb',
    version='0.2.9',
    author='Elmer de Looff',
    author_email='elmer@underdark.nl',
    packages=['uweb',
              'uweb.scripts',
              'uweb.pagemaker',
              'uweb.ext_lib.underdark',
              'uweb.ext_lib.underdark.libs',
              'uweb.ext_lib.underdark.libs.app',
              'uweb.ext_lib.underdark.libs.app.daemon',
              'uweb.ext_lib.underdark.libs.app.daemon.version',
              'uweb.ext_lib.underdark.libs.app.logging',
              'uweb.ext_lib.underdark.libs.sqltalk',
              'uweb.ext_lib.underdark.libs.sqltalk.mysql',
              'uweb.ext_lib.underdark.libs.sqltalk.sqlite',
              # Demo / example projects
              'uweb.base_project',
              'uweb.base_project.router',
              'uweb.logviewer',
              'uweb.logviewer.router',
              'uweb.uweb_info',
              'uweb.uweb_info.router'],
    include_package_data=True,
    package_data={'uweb': ['readme.txt'],
                  'uweb.pagemaker': ['http_500.utp',
                                     'admin/*.html'],
                  'uweb.base_project': ['base.conf',
                                        'readme.txt',
                                        'templates/*.utp'],
                  'uweb.logviewer': ['logging.conf',
                                     'static/logging.css',
                                     'static/database.js',
                                     'templates/*.html'],
                  'uweb.uweb_info': ['apache.conf',
                                     'example.conf',
                                     'readme.txt',
                                     'templates/*.html']},
    scripts=['uweb/scripts/uweb'],
    keywords=['web', 'framework', 'underdark'],
    url='http://uweb-framework.nl/',
    license='ISC',
    description='Underdark\'s minimal Web-framework.',
    long_description=open('README').read(),
    install_requires=[
        "lockfile>=0.9",
        "MySQL-python>=1.2",
        "pytz",
        "decorator",
        "simplejson",
        "python-magic",
        "python-openid",
    ],
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: ISC License (ISCL)',
        'Operating System :: MacOS :: MacOS X',
        'Operating System :: POSIX :: Linux',
    ]
)
