import types
import sys

from django.utils import simplejson
from django.http import HttpResponse
from django.http import Http404
from django.utils.log import getLogger
from django.conf import settings
from django.views import debug

logger = getLogger('django.request')


def json_response(data):
    return HttpResponse(simplejson.dumps(data, ensure_ascii=False),
                        mimetype='application/javascript')

    
def accept_ajax(view_func):
    def _wrap_view_func(request, *args, **kwargs):
        try:
            response = view_func(request, *args, **kwargs)

        except Http404, e:
            raise Http404(e)


        except Exception, e:
            if not request.is_ajax():
                raise e
                
            logger.error('Internal Server Error: %s' % request.path,
                         exc_info=sys.exc_info(),
                         extra={
                             'status_code': 500,
                             'request': request
                             }
                         )
            response = {'status_code': 500}
            if settings.DEBUG:
                response['debug_msg'] = debug.technical_500_response(request, *sys.exc_info()).content
            return json_response(response)

        if isinstance(response, types.DictType):
            response.setdefault('status_code', 200)
            return json_response(response)
        
        if isinstance(response, types.ListType):
            return json_response({'status_code': 200,
                                  'data': response})

        json_data = {'content': response.content,
                     'status_code':  response.status_code,
                     'headers': {}}

        # no other way to get all headers, except lookup protected variable
        json_data['headers'].update(response._headers)

        if 'location' in json_data['headers']:
            json_data['location'] = json_data['headers']['location'][1]

        new_response = json_response(json_data)
        new_response.cookies = response.cookies
        return new_response

    return _wrap_view_func
