#!/usr/bin/env python
# coding=UTF-8

__author__ = "Pierre-Yves Langlois"
__copyright__ = "https://github.com/pylanglois/uadm/blob/master/LICENCE"
__credits__ = ["Pierre-Yves Langlois"]
__license__ = "BSD"
__version__ = "1.0"
__maintainer__ = "Pierre-Yves Langlois"
__status__ = "Production"

"""
This is an example script using the uadm scripting tools
"""

import sys
import re

from uadm.uadmcore import *

def get_input_string(prompt, default_val=None):
    prompt = prompt + " " if not default_val else prompt + " [%s] " % default_val
    user_in = raw_input(prompt)
    if default_val is not None and user_in == "":
        user_in = default_val
    return user_in

def get_input_choices(prompt, choices_list):

    str_choices = ""
    default_val = None
    for c in choices_list:
        str_choices += c + "/"
        if c.isupper():
            default_val = c

    prompt = prompt + " [%s] " % str_choices[:len(str_choices)-1]
    user_in = None
    retry = 0
    while retry < 3 and user_in is None:
        user_in = raw_input(prompt)

        if default_val is not None and user_in == "":
            user_in = default_val

        if user_in not in choices_list and user_in.upper() not in choices_list:
            user_in = None
        retry += 1

    if user_in is None:
        print "Error. Valid answer are: %s" % choices_list
        exit(1)

    return user_in.lower()

def is_valid_hostname(hostname):
    if len(hostname) > 255:
        return False
    if hostname[-1:] == ".":
        hostname = hostname[:-1] # strip exactly one dot from the right, if present
    allowed = re.compile("(?!-)[A-Z\d-]{1,63}(?<!-)$", re.IGNORECASE)
    return all(allowed.match(x) for x in hostname.split("."))

vhost_template = """
<VirtualHost *:80>
        ServerAdmin %(admin_mail)s

%(server_name_alias)s
        DocumentRoot /var/www/%(site_url)s

%(rewrite_cond)s

        <Directory />
                Options Indexes FollowSymLinks MultiViews
                AllowOverride All
                Order allow,deny
                allow from all
        </Directory>

        #PHP log
        php_flag log_errors on
        php_value error_log /var/www/%(site_url)s/logs/%(site_url)s_php_error.log

        #Client apache log
        ErrorLog /var/www/%(site_url)s/logs/%(site_url)s_error.log
        CustomLog /var/www/%(site_url)s/logs/%(site_url)s_access.log combined

        #Server apache log
        ErrorLog /var/log/apache2/error.log
        CustomLog /var/log/apache2/access.log combined

        # Possible values include: debug, info, notice, warn, error, crit,
        # alert, emerg.
        LogLevel warn
</VirtualHost>
"""

logrotate_template = """
/var/www/%(site_url)s/logs/*.log {
        weekly
        missingok
        rotate 52
        compress
        delaycompress
        notifempty
        create 640 www-data www-data
        sharedscripts
        postrotate
                if [ -f "`. /etc/apache2/envvars ; echo ${APACHE_PID_FILE:-/var/run/apache2.pid}`" ]; then
                        /etc/init.d/apache2 reload > /dev/null
                fi
        endscript
}
"""

index_template = """
Welcome to yours site!
"""

auto_mount_template = """
"""
def build_vhost(admin_mail, site_name, add_www_redirect):

    server_name_alias = ""
    rewrite_cond = ""
    site_url = ""

    if add_www_redirect == 'y':
        server_name_alias = str(""
            "        ServerName www.%(site_name)s\n"
            "        ServerAlias %(site_name)s\n"
            "        ServerAlias dev.www.%(site_name)s\n" 
            % {
                "site_name":site_name,
            })
        rewrite_cond = str(""
            "        RewriteEngine on\n"
            "        RewriteCond %(http_post)s ^%(site_rewrite_cond)s$ [NC]\n"
            "        RewriteRule ^(.*)$ http://www.%(site_name)s$1 [R=301,L]\n"
            % { 
                "http_post":"%{HTTP_HOST}",
                "site_rewrite_cond":site_name.replace(".","\."),
                "site_name":site_name,
            })
        site_url = "www.%s" % site_name
    else:
        server_name_alias = str(""
            "        ServerName %(site_name)s\n"
            "        ServerAlias dev.%(site_name)s\n" % {"site_name":site_name})
        site_url = site_name
    
    vhost = vhost_template % {
        "admin_mail":admin_mail,
        "server_name_alias":server_name_alias,
        "rewrite_cond":rewrite_cond,
        "site_url":site_url,
    }
    
    logrotate = logrotate_template % {
        "site_url":site_url,
    }

    return vhost, logrotate, site_url

def run(args = []):
    #Config override example:
    mod_conf({
        #"UADM_TOOL_NAME" : unicode(sys.argv[0].split(".")[0]),
        #"UADM_LOG_PATH" : u"/var/log/uadm",
        #"UADM_SMTP_SERVER" : u"smtp.example.com",
        #"UADM_SRC_EMAIL" : u"tech@example.com",
        #"UADM_SUCCESS_SUBJECT" : u"Success",
        #"UADM_ERROR_SUBJECT" : u"Error",
        #"UADM_REPORT_ON_SUCCESS" : False,
        "UADM_DISABLE_MAIL" : True,
    })
    
    admin_mail = CONF_MAP["UADM_SRC_EMAIL"]
    site_name = HOST_INFO["hostname"]
    add_www_redirect = ['Y','n']
    use_auto_mount = ['Y','n']
    www_root_sec_group = None
    www_root_sec_group_create = ['y','N']
    
    #Ask for admin mail
    admin_mail = get_input_string("What is the server admin email (yours)?", admin_mail)

    #Ask for site name
    site_name = get_input_string("What is the dns name of the new site?", site_name)
    if not is_valid_hostname(site_name):
        print "'%s' is not a valid hostname!!!" % site_name
        exit(1)
   
    #Ask for www redirect
    if not site_name.startswith("www."):
        choices = add_www_redirect
        add_www_redirect = get_input_choices("Do you want to redirect %s to www.%s automatically?" % (site_name, site_name), add_www_redirect)
    else:
        add_www_redirect = 'n'

    #Ask for group name
    www_root_sec_group = get_input_string("Which unix/centrify group will be use to grant the access to document root directory?", site_name)

    #Ask for group creation
    www_root_sec_group_create = get_input_choices(str("Do you want to create a unix group for %s? "
                                                "If no, make sure that the group exists or the script will fail." % www_root_sec_group), www_root_sec_group_create)

    #Ask for auto_mount
    use_auto_mount = get_input_choices("Do you want use auto mount in /home/user/%s?" % site_name, use_auto_mount)

    ready_to_go = """
    OK, ready to go. Are those info correct?

    admin_mail = %(admin_mail)s
    site_name = %(site_name)s
    add_www_redirect = %(add_www_redirect)s
    use_auto_mount = %(use_auto_mount)s
    www_root_sec_group = %(www_root_sec_group)s
    www_root_sec_group_create = %(www_root_sec_group_create)s

>>>""" % {
    "admin_mail": admin_mail,
    "site_name" : site_name,
    "add_www_redirect" : add_www_redirect,
    "use_auto_mount" : use_auto_mount,
    "www_root_sec_group" : www_root_sec_group,
    "www_root_sec_group_create" : www_root_sec_group_create,
    }

    ready = get_input_choices(ready_to_go, ['Y','n'])
    if ready == 'y':

        vhost, logrotate, site_url = build_vhost(admin_mail, site_name, add_www_redirect)
        index = index_template

        root_dir = "/var/www/%s" % site_url
        cmd_list = [
            str('mkdir -p %s/logs' % root_dir),
            str('chown -R www-data:www-data %s' % root_dir),
            str('setfacl -R    -m g:%s:rw %s' % (www_root_sec_group, root_dir)),
            str('setfacl -R -d -m g:%s:rw %s' % (www_root_sec_group, root_dir)),
        ]
        
        completed, ret_map = exec_cmd_list(cmd_list)
        if not completed:
            print "FAILED!"
            exit(1)

        if use_auto_mount == 'y':
            cmd_list.append(str(
                ""
            ))


