#!/usr/bin/env python
# coding=UTF-8

__author__ = "Pierre-Yves Langlois"
__copyright__ = "https://github.com/pylanglois/uadm/blob/master/LICENCE"
__credits__ = ["Pierre-Yves Langlois"]
__license__ = "BSD"
__version__ = "1.0"
__maintainer__ = "Pierre-Yves Langlois"
__status__ = "Production"

import os
from uadm.uadmcore import *

if __name__ == '__main__':

    mod_conf({
        'UADM_PAM_SCRIPT_USE_CENTRIFY' : False,
        'UADM_PAM_SCRIPT_CENTRIFY_ADMINGROUP' : "Domain Admins",
    }, override=False)

    mod_conf({
        'UADM_DISABLE_MAIL' : True,
    })

    admin_group = CONF_MAP['UADM_PAM_SCRIPT_CENTRIFY_ADMINGROUP']
    pam_user = os.getenv('PAM_USER')

    cmd_list = ['bash -c \'id %s | grep "27(sudo)\|0(root)"  2> /dev/null\'' % pam_user]
    if CONF_MAP['UADM_PAM_SCRIPT_USE_CENTRIFY']:
        cmd_list.append('bash -c \'adquery user %s -A 2> /dev/null | grep "%s"\'' % (pam_user, admin_group))

    is_admin = False
    for c in cmd_list:
        ret = run_cmd(c)
        is_admin = is_admin if ret["return_code"] != 0 else True
    
    if not is_admin:
        l().info("..chrooting..")
        cmd_list = [
            'mkdir -p /home/%(user)s' % {'user':pam_user},
            'chown root:%(user)s /home/%(user)s' % {'user':pam_user},
            'run-parts --report --arg="mount" /usr/local/bin/auto_mount_www/',
        ]
        exec_cmd_list(cmd_list)

