import os
import stat
import shutil
from setuptools import setup
from pkg_resources import resource_string
from setuptools.command.install import install as _install

script_list = [
    "auto_mount_template.py",
    "backup.py",
    "checkvmtools.py",
    "example.py",
    "newsite.py",
    "pam_script_ses_open.py",
    "updateos.py",
]

template_list = [
    "template_*",
]

class install(_install):
    def run(self):
        _install.run(self)
        if not os.path.exists("/var/log/uadm"):
            os.mkdir("/var/log/uadm")
        if not os.path.exists("/etc/uadm/uadm.conf"):
            shutil.copy('uadm/uadm.conf','/etc/uadm/uadm.conf')
        for script in script_list:
            os.chmod("/etc/uadm/scripts/%s" % script, stat.S_IRUSR|stat.S_IWUSR|stat.S_IXUSR|stat.S_IRGRP|stat.S_IXGRP|stat.S_IROTH|stat.S_IXOTH)

def read(fname):
    return resource_string(__name__, fname)

setup(
    name = "uadm",
    version = "0.7.3",
    author = "Pierre-Yves Langlois",
    author_email = "pierreyves.langlois@gmail.com",
    description = ("UADM - Ubuntu administration scripts. A set of script that allows to automate task and notify the administrator by mail when thing went wrong. Update os, backup directories on a remote samba server, auto reinstall vmware tools on new kernel."),
    license = read('LICENCE'),
    keywords = "uadm ubuntu administration script",
    url = "https://github.com/pylanglois/uadm",
    packages=['uadm'],
    package_data={'uadm' : ["%s" % s for s in template_list] },
    long_description=read('README.md'),
    classifiers=[
        "Development Status :: 4 - Beta",
        "Environment :: Console",
        "Operating System :: Unix",
        "Programming Language :: Python",
        "Topic :: Utilities",
        "Topic :: System :: Systems Administration",
        "License :: OSI Approved :: BSD License",
    ],
    scripts=["uadm/uadm"],
    data_files=[
        ("/etc/uadm/scripts", ["uadm/%s" % s for s in script_list]),
    ],
    cmdclass={'install': install},
)
