#!/usr/bin/env python
# coding=UTF-8

__author__ = "Pierre-Yves Langlois"
__copyright__ = "https://github.com/pylanglois/uadm/blob/master/LICENCE"
__credits__ = ["Pierre-Yves Langlois"]
__license__ = "BSD"
__version__ = "1.0"
__maintainer__ = "Pierre-Yves Langlois"
__status__ = "Production"

"""
This script will check if vmware tools were installed using this script for 
the running kernel. If the tools were not installed, the script will try
to install them automatically.

Run this script at boot time to make sure that the vmtools are always
running.
"""
import sys

from uadm.uadmcore import *

def run(args = []):
    send_report(u"The computer has rebooted.", subject_prefix = "INFO")

    cmd_list = [
        "mkdir -p /var/lib/uadm",
        cfb(str("""
            bash -c "
                [[ -f /var/lib/uadm/checkkernel_`uname -r` ]] 
                &&  
                    (echo No new kernel;) 
                ||  
                    (echo A new kernel was installed;
                    /usr/bin/vmware-config-tools.pl -d
                        && (touch /var/lib/uadm/checkkernel_`uname -r`;
                            echo VMTools were upgraded;
                            exit 0;)
                    )
            "
            """,
        )),
    ]

    exec_cmd_list(cmd_list)

if __name__ == "__main__":
    run(sys.argv)
