#!/usr/bin/env python
# coding=UTF-8

__author__ = "Pierre-Yves Langlois"
__copyright__ = "https://github.com/pylanglois/uadm/blob/master/LICENCE"
__credits__ = ["Pierre-Yves Langlois"]
__license__ = "BSD"
__version__ = "1.0"
__maintainer__ = "Pierre-Yves Langlois"
__status__ = "Production"

"""
This script will automatically update the system and reboot it if needed.

Add this script to a cron own by root. Ex:
#this will run the script every Tuesday, Wednesday and Thursday at 6:05
05 6    * * 2-4   root    /path/to/script/uadm_autoupdate.py
"""

import sys

from uadm.uadmcore import *

def run(args = []):
    cmd_list = [
        "apt-get update",
        "apt-get dist-upgrade -y",
        "sleep 1",
        "bash -c \"[[ -f /var/run/reboot-required ]] && reboot now || echo 'no need to reboot' \""
    ]

    exec_cmd_list(cmd_list)

if __name__ == "__main__":
    run(sys.argv)
