uadm
====

UADM - Ubuntu administration scripts. This project aims to use python to automate server administration task and notify the administrator by mail when things went wrong. It contains precoded script like: update os, backup directories on a remote samba server,  auto reinstall vmware tools on new kernel, create a new apache site with openssh chroot...  

# Prerequisite  

- Centrify [optionnal]  

# Installation  

>sudo apt-get install python-pip  
>sudo pip install uadm  

## Edit the config file  
>sudo nano /etc/uadm/uadm.conf  

## updateos
>sudo nano /etc/crontab  
Add this line at the ends of the file:  
> 05 6 * * 2-4 root uadm updateos  

## newsite script with centrify and auto_mount

Activate pam_script for auto_mount  
> sudo nano /etc/pam.d/common-session  
Add this line before "session	required pam_unix.so"  
> session required        pam_script.so runas=root  

Create empty open and close script  
> sudo bash -c "echo '#! /bin/bash' > /usr/share/libpam-script/pam_script_ses_open"  
> sudo bash -c "echo '#! /bin/bash' > /usr/share/libpam-script/pam_script_ses_close"  
> sudo chmod +x /usr/share/libpam-script/pam_script_ses*  

Linking uadm pam_script_ses_open  
> sudo rm /usr/share/libpam-script/pam_script_ses_open  
> sudo ln -s  /etc/uadm/scripts/pam_script_ses_open.py  /usr/share/libpam-script/pam_script_ses_open  

sftp chroot  
> sudo nano /etc/ssh/sshd_config  
> Match Group "*,!sudo,!domain admins"  
>          ChrootDirectory /home/%u  
>          ForceCommand internal-sftp  
>          AllowTCPForwarding no  
>          X11Forwarding no  

# Upgrade

>sudo pip install --upgrade uadm  

;)

# Usage

Edit the file /etc/uadm/uadm.conf to match your own reality!  
Create your script in /etc/uadm/scripts/myscript based on /etc/uadm/scripts/example.py  
Call your script with:  
>sudo uadm myscript  

# Work in progress!!

This is a work in progress. Any suggestion for a cleaner deployment or new scripts is welcome! https://github.com/pylanglois/uadm  

# Known Issue:

## newsite script

When using centrify, you need to manually add the group in /etc/centrifydc/groups.allow for each site



