# Contributing

To contribute to this repository, here is a quick guide.

Fork and clone the repository:
```
git clone git@github.com:your-git-username/uberpy.git
```

Make changes and add tests.

Push to the fork and [submit a pull request] [pr]

[pr]: https://github.com/vivangkumar/uberpy/compare/

I will try to respond to pull requests as soon as possible.
Please make sure you type an appropriate commit message.
Please also ensure tests are written.

## A few guidelines and standards
Most of the guidelines are as per [The Python Style Guide] (https://www.python.org/dev/peps/pep-0008)

- Use 4 spaces per indentation level. Continuation lines should align wrapped elements vertically.
- Keep line length to less than 128 characters.
- Separate top-level function and class definitions with two blank lines.
- Method definitions inside a class are separated by a single blank line.
- Code in the core Python distribution should always use UTF-8.
- Add imports to the top of the file; each import should preferably be on a new line.
- Group similar imports together.
- Write docstrings for all public modules, functions, classes, and methods. 
  Docstrings are not necessary for non-public methods, but have a comment that describes what the method does. 
  This comment should appear after the def line.
- For class names, use *CapWords* convention; for functions and variables, use *lower_case_with_underscores*


