"""Device call classes.

These classes implement any response cleaning and validation needed.  If a
call class isn't defined for a given method then one is created using
ubersmith.calls.BaseCall.

"""

from ubersmith.calls import BaseCall
from ubersmith.clean import clean
from ubersmith.utils import prepend_base

__all__ = [
    'GetCall',
    'ListCall',
    # 'ModuleGraphCall',
    'MonitorListCall',
]

_ = prepend_base(__name__.split('.')[-1])


_DEVICE_CLEANER = clean(dict, values={
    'active': 'int',
    'cage_id': 'int',
    'clientid': 'int',
    'dev': 'int',
    'devtype_group_id': 'int',
    'disabled': 'int',
    'down': 'int',
    'fac_id': 'int',
    'owner': 'int',
    'parent': 'int',
    'rack_id': 'int',
    'row_id': 'int',
    'total': 'int',
    'type_id': 'int',
    'up': 'int',
    'warn': 'int',
    'zone_id': 'int',
    'depth': float,
    'height': float,
    'width': float,
})


class GetCall(BaseCall):
    method = _('get')
    required_fields = ['device_id']
    cleaner = _DEVICE_CLEANER


class ListCall(BaseCall):
    method = _('list')
    cleaner = clean(dict, keys='int', values=_DEVICE_CLEANER)


class ModuleGraphCall(BaseCall):
    method = _('module_graph')


class MonitorListCall(BaseCall):
    method = _('monitor_list')
    required_fields = ['protocol']
    cleaner = clean(dict, keys='int', values=clean(dict, values={
        'dev': 'int',
        'script_id': 'int',
        'last_change': 'timestamp',
        'last_notified': 'timestamp',
        'last_poll': 'timestamp',
    }))
