"""
    ufl.core.structures.enum
    ~~~~~~~~~~~~~~~~~~~~~~~~

    Provides structure types similar to *enums* found in many other languages.

    :copyright: Copyright 2009-2011 UFL team. See AUTHORS for details.
    :license: GPLv3
"""


__all__ = ["simple_enum"]


#: http://stackoverflow.com/questions/36932/#1695250
def simple_enum(*sequential, **named):
    """Create a basic enumeration type."""
    enums = dict(zip(sequential, range(len(sequential))), **named)
    return type("Enumeration", (), enums)
