#!/usr/bin/env python2
from distutils.core import setup
from ufl import __doc__, __version__
setup(
    name = "ufl-python",
    version = __version__,
    packages = [
        "ufl",
        "ufl.core",
        "ufl.os",
        "ufl.io",
        "ufl.core.structures",
        "ufl.core.graphics",
        "ufl.os.xlib"
    ],
    description = "".join(map(str.strip, __doc__.split("\n")[4:6])),
    long_description = __doc__,
    maintainer = "David Gidwani",
    maintainer_email = "david.gidwani AT gmail DOT com",
    url = "http://dave.uni.cx/project/ufl",
    keywords = ["ufl", "general-purpose"],
    classifiers = [
        "Programming Language :: Python",
        "Development Status :: 1 - Planning",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU General Public License (GPL)",
        "Operating System :: OS Independent",
        "Topic :: Software Development :: Libraries",
    ],

    extras_require = {
        'core.graphics.color': ["PIL"],
    }
)
