"""
    ufl.core.structures.list
    ~~~~~~~~~~~~~~~~~~~~~~~~

    Provides various helper functions to lists and tuples, stuff that would be
    really nice to have in :mod:`itertools`.

    :copyright: Copyright 2009-2011 UFL team. See AUTHORS for details.
    :license: GPLv3
"""
from collections import Iterable


def flatten(list_):
    """Flatten a list (of any depth)."""
    if isinstance(list_, Iterable) and not isinstance(list_, basestring):
        return [sub for elem in list_ for sub in flatten(elem)]
    else:
        return [list_]


class MultiGetList(list):

    def __getitem__(self, index):
        if isinstance(index, tuple):
            return map(super(MultiGetList, self).__getitem__, index)
        else:
            return super(MultiGetList, self).__getitem__(index)
