from decorator import decorator
from myhdl import Simulation


@decorator
def run_sim_deco(f, *args, **kwargs):
    gens = f(*args, **kwargs)
    Simulation(gens).run()


def run_sim(*args, **kwargs):
    if callable(args[0]):
        return run_sim_deco(args[0])
    else:
        Simulation(*args).run(**kwargs)
