#!/usr/bin/env python
# To create a distribution package for pip or easy-install:
# python setup.py sdist
from setuptools import setup, find_packages
from os.path import join, dirname, realpath
from warnings import warn

import uilayer

setup(
    name='uilayer',
    author=uilayer.__author__,
    author_email=uilayer.__email__,
    url='https://github.com/paulmueller/uilayer',
    version=uilayer.__version__,
    packages=['uilayer'],
    package_dir={'uilayer': 'uilayer'},
    license=uilayer.__license__,
    description='python user interface layer to monitor progress of long-running algorithms',
    long_description=open(join(dirname(__file__), 'README.txt')).read(),
    keywords=["ui", "user", "interface", "progress", "process"],
    extras_require={
                    'doc': ['sphinx']
                   },
    classifiers= [
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.2',
        'Programming Language :: Python :: 3.3',
                 ],
    platforms=['ALL']
    )

