#!/usr/bin/env python
# To create a distribution package for pip or easy-install:
# python setup.py sdist
from setuptools import setup, find_packages
from os.path import join, dirname, realpath
from warnings import warn

import uilayer

name='uilayer'

setup(
    name=name,
    author=uilayer.__author__,
    author_email=uilayer.__email__,
    version=uilayer.__version__,
    license=uilayer.__license__,
    url='https://github.com/paulmueller/uilayer',
    packages=[name],
    package_dir={name: name},
    description='python user interface layer to monitor progress of long-running algorithms',
    long_description=open(join(dirname(__file__), 'README.txt')).read(),
    keywords=["ui", "user", "interface", "progress", "process"],
    extras_require={
                    'doc': ['sphinx']
                   },
    classifiers= [
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.3',
                 ],
    platforms=['ALL']
    )

