"""An API for the UK Police Data Service

.. moduleauthor:: Tyndyll <police@tyndyll.net>

As part of the data.gov.uk program the UK Government has released information
for UK Police forces across the country via an API. The API provides a rich data
source for information, including

* Neighbourhood team members
* Upcoming events
* Crime statistics at both street and neighbourhood level
* Outcomes for street level crimes
* Nearest police stations

The API is implemented as a standard JSON web service using HTTP GET requests.
Full request and response examples are provided in the documentation.

This module provides a method to interface with this API without having to
worry about making appropriate REST calls, or formatting the request data
 to the required structure.
"""

__author__ = 'tyndyll'

import exceptions
import police
import crime
import service