__author__ = 'tyndyll'

import geopy
import re
import ukpolice
import unittest


class TestCrime(unittest.TestCase):

    def test_crime_available_dates_returns_populated_list(self):
        results = ukpolice.crime.available_dates()
        self.assertTrue(len(results) > 0)

    def test_crime_available_dates_returns_valid_responses(self):
        results = ukpolice.crime.available_dates()
        for i in results:
            self.assertTrue(re.match(r'20\d{2}\-\d{2}', i))

    def test_street_crime_by_point_returns_results(self):
        data = ukpolice.crime.street_by_point(geopy.Point("51.500144", "-0.124828"), '2012-12')
        self.assertEqual(len(data), 3330)

    def test_street_crime_by_area_plot_returns_results(self):
        point1 = geopy.Point(51.502522, -0.140449)
        point2 = geopy.Point(51.500144, -0.124828)
        point3 = geopy.Point(51.508876, -0.126987)
        data = ukpolice.crime.street_by_area([point1, point2, point3], '2012-12')
        self.assertEqual(len(data), 75)

    def test_available_dates_are_in_date_format(self):
        for date_entry in ukpolice.crime.street_level_availability():
            self.assertTrue(re.match(r'20\d{2}\-\d{2}', date_entry))

    def test_street_outcomes_at_point(self):
        data = ukpolice.crime.street_outcomes_by_id(956661, '2013-01')
        self.assertEqual(len(data), 1)

    def test_street_outcomes_at_point_when_no_crime(self):
        data = ukpolice.crime.street_outcomes_by_id(956661, '2012-12')
        self.assertEqual(len(data), 0)

    def test_street_outcomes_by_point(self):
        data = ukpolice.crime.street_outcomes_by_point(geopy.Point("51.500144", "-0.124828"), '2012-12')
        self.assertEqual(len(data), 1188)

    def test_specific_crime(self):
        data = ukpolice.crime.crime_detail('3db71924af6f9c76efec6f11fc1238dc7ed64e2eaf84a0d650d878f7e4c50ec7')



if __name__ == "__main__":
    unittest.main()