import geopy
import re
import unittest
import ukpolice


class TestForce(unittest.TestCase):

    def test_all_forces_have_objects(self):
        results = ukpolice.police.list_all_force_ids()
        for i in results.keys():
            f = ukpolice.police.get_force_by_id(i)
            self.assertTrue(f is not None)

    def test_non_existent_id_raises_exception(self):
        with self.assertRaises(ukpolice.exceptions.ForceNotFoundException):
            ukpolice.police.get_force_by_id("non-existent-id")

    def test_returns_named_force(self):
        f = ukpolice.police.get_force_by_name("bedfordshire POLICE")
        self.assertEqual("Bedfordshire Police", f.name)

    def test_non_existent_name_returns_none(self):
        with self.assertRaises(ukpolice.exceptions.ForceNotFoundException):
            ukpolice.police.get_force_by_name("Not a Real Name")

    def test_force_properties(self):
        f = ukpolice.police.get_force_by_id("city-of-london")
        self.assertEquals(f.name, "City of London Police")
        self.assertEquals(f.id, "city-of-london")
        self.assertEquals(f.url, "http://www.cityoflondon.police.uk/")
        self.assertEquals(f.phone, "101")

    def test_force_at_point(self):
        point = geopy.Point("51.500144", "-0.124828")
        f = ukpolice.police.get_force_by_point(point)
        self.assertEqual(f.name, "Metropolitan Police Service")

    def test_neighbourhood_at_point(self):
        point = geopy.Point("51.500144", "-0.124828")
        n = ukpolice.police.get_neighbourhood_by_point(point)
        self.assertEqual(n.name, "Strand and Whitehall")