__author__ = 'tyndyll'


class ForceNotFoundException(Exception):

    def __init__(self, name):
        self.__name = name

    def __str__(self):
        return "%s does not identify a police force" % self.__name;


class NeighbourhoodNotFoundException(Exception):

    def __init__(self, name):
        self.__name = name

    def __str__(self):
        return "%s does not identify a neighbourhood" % self.__name


class InvalidApiDateException(Exception):

    def __init__(self, excepted_date):
        self.__date = excepted_date

    def __str__(self):
        return "%s is not a valid API date"


class TooManyCrimesException(Exception):

    def __str__(self):
        return "Too many crimes for the specified request. Limited to 10000 by the API"


class NoJSON(Exception):

    def __str__(self):
        return "The service did not respond with valid JSON"