__author__ = 'tyndyll'

import exceptions
import json
import urllib
import urllib2

BASE_URL = "http://data.police.uk/api/"


class Street:

    def __init__(self, id, name):
        self.__id = id
        self.__name = name

    @property
    def id(self):
        return self.__id

    @property
    def name(self):
        return self.__name


def fetch_data(url, **kwargs):
    global BASE_URL
    urlbase = BASE_URL
    params = urllib.urlencode(kwargs)
    url = (urlbase + url + "?" + params)
    req = urllib2.Request(url.replace(" ", "%20"))
    print req.get_full_url()
    f = urllib2.urlopen(req)
    response = f.read()
    return response


def fetch_json(url, **kwargs):
    data = fetch_data(url, **kwargs)
    try:
        return json.loads(data)
    except ValueError as e:
        if e.message == "No JSON object could be decoded":
            raise exceptions.NoJSON("JSON data could not be found")