# This setup.py was generated automatically by Pyron.
# For details, see http://pypi.python.org/pypi/pyron/

from setuptools import setup, find_packages

setup(
    name = 'uncommitted',
    version = '1.0',
    description = u'Scan Version Control For Uncommitted Changes',
    long_description = u'\nWhen working on one version-controlled project on my hard drive, I often\nflip over quickly to another project to make a quick change.  By the end\nof the day I have forgotten about that other change and often find it\nmonths later when I enter that repository again.  I needed a way to be\nalerted at the end of each day about any uncommitted changes sitting\naround on my system.\n\nThus was born this "uncommitted" script: using either your system\n*locate(1)* command or by walking a filesystem tree on its own, it will\nfind version controlled directories and print a report on the standard\noutput about any uncommitted changes still sitting on your drive.  By\nrunning it from a *cron(8)* job you can make this notification routine.\n\nRunning "uncommitted"\n---------------------\n\nBy default "uncommitted" uses the *locate(1)* command to scan for\nrepositories, which means that it can operate quickly even over very\nlarge filesystems like my home directory::\n\n    $ uncommitted ~\n\nBut you should **be warned:** because the *locate(1)* database is only\nupdated once a day on most systems, this will miss repositories which\nyou have created since its last run.  To be absolutely sure to see all\ncurrent repositories, you should instead ask "uncommitted" to search the\nfilesystem tree itself.  To do this on your "devel" directory, for\nexample, you would type this::\n\n    $ uncommitted -w ~/devel\n\nNot only will the output of "-w" always be up-to-date, but it is usually\nfaster for small directory trees.  The default behavior (which can also\nbe explicitly requested, with "-l") is faster when the directory tree\nyou are searching is very large.\n\nShould you ever want a list of all repositories, and not just those with\nuncommitted changes, you can use the "-v" verbose option::\n\n    $ uncommitted -v ~\n\nYou can always get help by running "uncommitted" without arguments or\nwith the "-h" or "--help" options.\n\nSupported VCs\n-------------\n\nAt the moment, "uncommitted" supports:\n\n* `Mercurial`_ (.hg directories)\n* `Subversion`_ (.svn directories)\n\nIt needs to support `Git`_ soon, since that DVCS is in widespread use.\nHowever, I am not familiar enough with Git\'s output to write a function\nfor it myself.  When I tried out Git a few minutes ago, its status\nmessages were crazy, with all sorts of hash characters everywhere; it\nlooked like it was suffering from an acute lack of confidence, and was\ntherefore commenting out all of its own output.  Anyway, there is\nprobably some simple way to make Git report on uncommitted changes, but\nI will leave it to a Git fan to figure out how, if they would like to\ncontribute a patch back.\n\nI would also not be opposed to someone contributing a Bazaar plugin.\nBut CVS should probably never be supported by "uncommitted" because that\nmight imply that it is still an acceptible system to be using.\n\nIt occurs to me that there might already be some version control\nabstraction layer that I should be using for this, rather than figuring\nout how to run each version control system myself; a quick search of\nPyPI suggests that I take a closer look at the `pyvcs`_ project.  Maybe\nthat can be a useful direction for the next phase of development!\n\n.. _Mercurial: http://mercurial.selenic.com/\n.. _Subversion: http://subversion.tigris.org/\n.. _Git: http://git-scm.com/\n.. _pyvcs: http://github.com/alex/pyvcs/blob/master/README.txt\n',
    author = 'Brandon Craig Rhodes',
    author_email = 'brandon@rhodesmill.org',
    url = 'http://bitbucket.org/brandon/uncommitted/',
    classifiers = ['Development Status :: 5 - Production/Stable', 'Environment :: Console', 'Intended Audience :: Developers', 'License :: OSI Approved :: MIT License', 'Topic :: Software Development :: Version Control', 'Topic :: Utilities'],

    package_dir = {'': 'src'},
    packages = find_packages('src'),
    include_package_data = True,
    install_requires = [],
    entry_points = '[console_scripts]\nuncommitted = uncommitted.command:main\n',
    )
