#    This file is part of unforward
# 
#    Unforward is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#    
#    Unforward is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#    
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#

import email
import email.parser
import email.message
import emailclients
from unforward.errors import NoForwardFoundError

class Extractor:
    """ This is the main class which handles extracting the original email from a chain of forwarded emails."""
    def __init__(self):
        self.parser = email.parser.Parser()
        # Grab the list of clients from the emailclients module
        self.clients = [client() for client in emailclients.clients]
    
    def get_client(self, name):
        for client in self.clients:
            if client.client_type == name:
                return client
        return None
    
    def extract(self, email_text):
        """ Assuming that email_text is a mime-encoded email message containing a forward,
            this will extract the original body email and sender, and return them in a
            a dictionary. """
        
        email = self.parser.parsestr(email_text)
        payload = email.get_payload()
        if isinstance(payload, list):
            print payload.items()
        else:
            return self.extract_from_html(payload)
        
        print email
        
        
        
    def extract_from_html(self, email_html):
        """ Assuming that email_html is the raw html extracted from an email message,
            this method will attempt to determine if it contains a forwarded message,
            and if so, it will extract the original message. """
        for client in self.clients:
            # Use the first client which indicates that it matches the email html
            try:
                if client.check_match(email_html):
                    return client.extract_from_html(email_html)
            except NotImplementedError:
                pass # Ignore unimplemented clients
        raise NoForwardFoundError()

