#    This file is part of unforward
# 
#    Unforward is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#    
#    Unforward is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#    
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#

import unforward
import fileinput
import json
import sys
from unforward.errors import NoForwardFoundError
from unforward.errors import ExtractionError

def main():
    """ The main starting point for the unforward script."""
    extractor = unforward.Extractor()
    try:
        if '--html' in sys.argv:
            sys.argv.remove('--html')
            email_text = ''.join(line for line in fileinput.input())
            result = extractor.extract_from_html(email_text)
        else:    
            email_text = ''.join(line for line in fileinput.input())
            result = extractor.extract(email_text)
        result['date'] = result['date'].strftime(r"%Y-%m-%dT%H:%M:%S %z")
        print(json.dumps(result))
    except ExtractionError as e:
        exit(2)
    except NoForwardFoundError as e:
        exit(1)
    


