#    This file is part of unforward
# 
#    Unforward is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#    
#    Unforward is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#    
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#

from emailclient import EmailClient
from unforward.errors import ExtractionError
from bs4 import BeautifulSoup


class OutlookExpressClient(EmailClient):
    """ Extracts originals from OutlookExpress clients"""
    
    client_type = 'outlook'
    implemented = True
    
    def extract(email):
        pass
    
    def check_match(self, string):
        """ This method should look at the given string, and as quickly as possible determine if it contains a
            forward from this email client. """
        return string.find('Begin forwarded message:') != -1 and string.find('<blockquote type="cite">') != -1
    
    def extract_from_html(self, string):
        try:
            parsed = BeautifulSoup(string)
            blockquotes = parsed.html.body.find_all('blockquote')
            sender = blockquotes[0].a.get_text()
            body = ''.join(str(tag).strip() for tag in blockquotes[1].contents)
            return {"body" : body, "sender" : sender}
        except Exception as e:
            raise ExtractionError("Given email did not parse as an outlook forward successfully: " + str(e))
        
    

