#    This file is part of unforward
# 
#    Unforward is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#    
#    Unforward is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#    
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#



class ExtractionError(ValueError):
    """ This Exception is used to indicate that extraction failed for some reason. """
    pass
    


class NoForwardFoundError(ValueError):
    """ This Exception is used to indicate that the extractor could not find any forwards
        within the email body."""
    pass


class NoHTMLPayloadFound(ValueError):
    """ This Exception is used to indicate that the extractor could not find any HTML payloads
        to extract from.."""
    pass
    
