#    This file is part of unforward
# 
#    Unforward is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#    
#    Unforward is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#    
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#

import unforward
import fileinput
import json
import sys
from unforward.errors import NoForwardFoundError
from unforward.errors import ExtractionError
from unforward.errors import NoHTMLPayloadFound
import logging
from pprint import pprint
import codecs

def main():
    """ The main starting point for the unforward script."""
    #sys.stdin = codecs.getreader('utf-8')(sys.stdin)
    email_text = sys.stdin.read()
    
    extractor = unforward.Extractor()
    try:
        if '--html' in sys.argv:
            result = extractor.extract_from_html(email_text)
        else:
            result = extractor.extract(email_text)
        result['date'] = result['date'].strftime(r"%Y-%m-%dT%H:%M:%S %z")
        print(json.dumps(result))
    except ExtractionError as e:
        logging.exception("")
        exit(3)
    except NoHTMLPayloadFound as e:
        logging.exception("")
        exit(4)
    except NoForwardFoundError as e:
        logging.exception("")
        exit(2)
    


