#    This file is part of unforward
# 
#    Unforward is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#    
#    Unforward is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#    
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#

import unittest
import unforward
from unforward.errors import ExtractionError
from examples import examples

class GenericUnforwardEmailClientTest(unittest.TestCase):
    examples =  examples
    
    def setUp(self):
        pass
        
    def tearDown(self):
        pass
    
    def _test_invalid_decode(self, client):
        invalid_examples = [example for example in self.examples if client not in example['client'] ]

        for example in invalid_examples:
            html = ''.join(open(unforward.get_data(example['file'])))
            def testfunc():
                result = self.decoder.extract_from_html(html)
            
            self.assertRaises(ExtractionError, testfunc)

    def _test_decode(self, client):
        examples = [example for example in self.examples if client in example['client'] ]

        for example in examples:
            html = ''.join(open(unforward.get_data(example['file'])))
            result = self.decoder.extract_from_html(html)
            
            self.assertEqual(result, example['result'])
    
    def _test_match(self, client):
        for example in self.examples:
            html = ''.join(open(unforward.get_data(example['file'])))
            
            if client in example['client']:
                self.assertTrue(self.decoder.check_match(html))
            else:
                self.assertFalse(self.decoder.check_match(html))

