#    This file is part of unforward
# 
#    Unforward is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#    
#    Unforward is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#    
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#

import unittest
import unforward
from unforward.errors import ExtractionError
from examples import examples

class ExtractorTest(unittest.TestCase):
    """ This test-case tests the general purpose extractor, including its ability to decide which
        email-client was used to forward the given message, and whether or not there was a forward
        in the message at all. """
    examples =  examples
    
    def setUp(self):
        self.extractor = unforward.Extractor()
        
    def tearDown(self):
        pass
    
    def test_automatch(self):
        for example in self.examples:
            html = ''.join(open(unforward.get_data(example['file'])))
            client = self.extractor.get_client(example['client'][0])
            # Only consider clients that are implemented.
            if client.implemented:
                result = self.extractor.extract_from_html(html)
                self.assertEqual(result, example['result'])
    
    def test_mime(self):
        mimetext = ''.join(open(unforward.get_data("examples/gmail_forward_2.mime")))
        result = self.extractor.extract(mimetext)
        expected = {'body': '<div><div><div>Comodo,<br/>\n<br/></div>I have to say that I am impressed by your thoroughness on our company background check. 5 stars for actually doing a background check.<br/><br/></div>Our accountant Tara is registered under the Chartered Professional Accountants of Ontario.<br/>\n<br/></div>Brad<br/>', 'sender': u'brad@getsensibill.com'}
        self.assertEqual(result, expected)
        
