#    This file is part of unforward
# 
#    Unforward is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#    
#    Unforward is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#    
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#

import unittest
import unforward
from unforward.errors import ExtractionError
from client_test import GenericUnforwardEmailClientTest

class TestGMailUnforward(GenericUnforwardEmailClientTest):
    def setUp(self):
        self.decoder = unforward.emailclients.gmail.GmailClient()
    
    def tearDown(self):
        pass
    
    def test_decode_example_1(self):
        """ This test uses the gmail forward example in the data directory to see if
            the extraction was successful. """
        self._test_decode(client = "gmail")

    def test_invalid_decode(self):
        """ This test checks to see that the gmail-parser returns an error if something other then
            a gmail-forward is passed in."""
        self._test_invalid_decode(client = 'gmail')

    def test_match(self):
        """ This test checks to see that the outlook-parser only matches outlook forwards."""
        self._test_match(client = 'gmail')




