#    This file is part of unforward
# 
#    Unforward is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#    
#    Unforward is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#    
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#

import os

from setuptools import setup, find_packages

here = os.path.abspath(os.path.dirname(__file__))

requires = [
        'beautifulsoup4',
        'lxml'
    ]

setup(name='unforward',
      version='0.1.7',
      description='unforward allows you to extract the original email from a chain of forwards.',
      long_description=""" """,
      classifiers=[
        "Programming Language :: Python",
        "Topic :: Database",
        ],
      author='Bradley Arsenault & Sensibill Inc.',
      author_email='brad@getsensibill.com',
      url='http://unforward.readthedocs.org/en/latest/',
      keywords='email',
      packages=find_packages(),
      include_package_data=True,
      zip_safe=False,
      install_requires=requires,
      tests_require=requires,
      test_suite="unforward",
      entry_points="""\
      [console_scripts]
      unforward = unforward.scripts.main:main
      """,
      )

