#    This file is part of unforward
# 
#    Unforward is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#    
#    Unforward is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#    
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#

from unforward.emailclients.emailclient import EmailClient
from unforward.errors import ExtractionError
from bs4 import BeautifulSoup
from pprint import pprint

class GmailClient(EmailClient):
    """ Extracts originals from gmail clients."""
    
    client_type = 'gmail'
    implemented = True
    
    def extract(self, email):
        pass

    def check_match(self, string):
        """ This method should look at the given string, and as quickly as possible determine if it contains a
            forward from this email client. """
        string = str(string)
        return string.find('gmail_sendername') != -1 and string.find('---------- Forwarded message ----------') != -1
    
    def extract_from_html(self, string):
        try:
            parsed = BeautifulSoup(string)
            gmail_quote = parsed.div.find("div", class_ = "gmail_quote")
            if gmail_quote.div is None:
                body = ''.join(str(tag).strip() for tag in gmail_quote.contents[18:])
                sender = gmail_quote.span.a.get_text()
            else:
                body = ''.join(str(tag).strip() for tag in gmail_quote.div.contents)
                sender = gmail_quote.span.a.get_text()
            return {"body" : body, "sender" : sender}
        except Exception as e:
            raise ExtractionError("Given email did not parse successfully: " + str(e))

        

